<?php
/**
 * Created by PhpStorm.
 * User: damien
 * Date: 31/01/2018
 * Time: 20:54
 */

namespace CloudFileStorage;


class CacheUtil
{
    private $baseCachePath="";

    const CACHE_LISTDIR_OPTERATION=0;
     const CACHE_GETMETADATAFILE_OPERATION=1;
     const CACHE_GETAUTHPROVIDERTOKENS_OPERATION=4;

    const CACHE_INVALIDALISTDIR_OPTERATION=2;
     const CACHE_INVALIDATEMETADATAFILE_OPERATION=3;
        const CACHE_INVALIDATEAUTHPROVIDERTOKENS_OPERATION=5;

    public function __construct($baseCachePath)
    {
        $this->baseCachePath=$baseCachePath;
    }

    private function startsWith($haystack, $needle) {
        $length = strlen($needle);
        return (substr($haystack, 0, $length) === $needle);
    }

    private function getOperationCachePath($operation,$value){
        if($this->startsWith($value,"/") && $value != "/") //Force la suppression d'un / devant le path pour être sûr d'appeler le même cache entre admin v1 et v2
            $value = substr($value, 1);
        $cacheOperationPath="";
        if($operation == CacheUtil::CACHE_LISTDIR_OPTERATION || $operation == CacheUtil::CACHE_INVALIDALISTDIR_OPTERATION) {
            $cacheOperationPath = $this->baseCachePath . "LIST_" . md5($value);
        }else if($operation == CacheUtil::CACHE_GETMETADATAFILE_OPERATION || $operation == CacheUtil::CACHE_INVALIDATEMETADATAFILE_OPERATION) {
            $cacheOperationPath = $this->baseCachePath . "OBJMETA_" . md5($value);
        }else if($operation == CacheUtil::CACHE_GETAUTHPROVIDERTOKENS_OPERATION || $operation == CacheUtil::CACHE_INVALIDATEAUTHPROVIDERTOKENS_OPERATION) {
            $cacheOperationPath = $this->baseCachePath . "AUTH_" . md5($value);
        }
        if($cacheOperationPath == "")
            throw new \Exception("Le type d'opération n'existe pas");
        return $cacheOperationPath;
    }
    public function cacheIsValid($operation,$value,$maxAgeMinutes=60){ //1H par défaut
        $cacheOperationPath = $this->getOperationCachePath($operation,$value);
        $maxOldCache = strtotime("-$maxAgeMinutes minutes");
        if(file_exists($cacheOperationPath) && filemtime($cacheOperationPath)> $maxOldCache){
            return true;
        }
        return false;
    }

    public function getCacheValue($operation,$value){
        $cacheOperationPath = $this->getOperationCachePath($operation,$value);

        if(!file_exists($cacheOperationPath))
            throw new \Exception("Le cache n'existe pas");
        return unserialize(file_get_contents($cacheOperationPath));
    }

    public function saveCacheValue($operation,$value,$content){
        $cacheOperationPath = $this->getOperationCachePath($operation,$value);
        file_put_contents($cacheOperationPath,serialize($content));
    }

    public function deleteCacheValue($operation,$value){
        $cacheOperationPath = $this->getOperationCachePath($operation,$value);
        if(file_exists($cacheOperationPath))
            unlink($cacheOperationPath);
    }
}