<?php
/**
 * Created by IntelliJ IDEA.
 * User: damien
 * Date: 18/06/2017
 * Time: 12:36
 */

namespace Actigraph\ModuleNavitiaIoBundle\Services;


use Actigraph\ActipageBaseBundle\Services\ActipageService;
use Symfony\Component\DependencyInjection\ContainerInterface;

class NavitiaIoService
{
    private $actipageService,$http,$moduleConfig;
    public function __construct($actiservice){
        $this->actipageService = $actiservice;
        $this->http = new \GuzzleHttp\Client();
        $this->moduleConfig = $this->actipageService->getSiteConfigForModule("navitiaIo");

    }
    public function getConfig(){
        return $this->moduleConfig;
    }
    private function getTraficReportPerturbations($currentPagenumber=0,&$perturbations=NULL){
        try{
            $urlApi = $this->moduleConfig["Api"]["url"]."traffic_reports?start_page=".$currentPagenumber;
            if(isset($this->moduleConfig["Api"]["networkid"]))
                $urlApi = $this->moduleConfig["Api"]["url"]."networks/".$this->moduleConfig["Api"]["networkid"]."/traffic_reports?start_page=".$currentPagenumber;

            $responseAPI = $this->http->get($urlApi, array(
                'timeout' => 2,
                'auth'=>array($this->moduleConfig["Api"]["token"],'')
            ));
            if($responseAPI->getStatusCode() != 200)
                throw new \Exception("Service non disponible. Code retour API : ".$responseAPI->getStatusCode());

            $page = json_decode($responseAPI->getBody(),true);
            $nombrePages = ceil($page["pagination"]["total_result"]/$page["pagination"]["items_per_page"]);
            if($perturbations==null)
                $perturbations = array();
            foreach ($page["disruptions"] as $perturb) {
                if($perturb["status"] == "passed")
                    continue;//pas la peine de prendre les perturb fini, uniquement les actives (maintenants) et future (programmé)
                $messageForChannelWeb = "";
                foreach ($perturb["messages"] as $message){
                    if(in_array("web",$message["channel"]["types"])){
                        $messageForChannelWeb = $message["text"];
                    }
                }
                $lignes = array();
                foreach ($perturb["impacted_objects"] as $impacted_object){
                    $pt_object = $impacted_object["pt_object"];
                    if($pt_object["embedded_type"] == "line" && !isset($lignes[$pt_object["line"]["id"]])){
                        $lignes[$pt_object["line"]["id"]]= array(
                            "id"=>$pt_object["line"]["id"],
                            "indiceId"=>str_replace(":","_",$pt_object["line"]["id"]),
                            "code"=>$pt_object["line"]["code"],
                            "nom"=>$pt_object["line"]["name"],
                        );
                    }

                }
                $perturbations[] = array(
                    "id"=>$perturb["disruption_id"],
                    "message"=>$messageForChannelWeb,
                    "lignes"=>$lignes,
                );
            }

            if(($nombrePages-1) != $currentPagenumber && is_numeric($nombrePages) && $nombrePages > 0){
                return $this->getTraficReportPerturbations($currentPagenumber+1,$perturbations);
            }else{
                return $perturbations;
            }
        }catch (\Exception $e){
            throw new \Exception("Service non disponible".$e->getMessage());
        }
    }
    public function getPerturbations(){
        $listeLignesImpact = array();

        $perturbations = $this->getTraficReportPerturbations();
        if(count($perturbations)>0){
            //extraction des lignes uniquements pour l'affichage en accueil
            foreach($perturbations as $perturb){
                foreach($perturb["lignes"] as $ligne){
                    if(!isset($listeLignesImpact[$ligne["id"]])){
                        $listeLignesImpact[$ligne["id"]] = array(
                            "perturbations"=>array(),
                            "ligne"=>$ligne
                        );
                    }
                    $listeLignesImpact[$ligne["id"]]["perturbations"][]=array(
                        "id"=>$perturb["id"],
                        "message"=>$perturb["message"],
                    );

                }
            }
        }
        return $listeLignesImpact;
    }
    public function getSelectListeLigne($currentPagenumber=0,&$tableauLignes=NULL){
        try{
            $responseAPI = $this->http->get($this->moduleConfig["Api"]["url"]."lines?start_page=".$currentPagenumber, array(
                'timeout' => 2,
                'auth'=>array($this->moduleConfig["Api"]["token"],'')
            ));
            if($tableauLignes == null)
                $tableauLignes = array();

            if($responseAPI->getStatusCode() != 200)
                throw new \Exception("Service non disponible");

            $resp = json_decode($responseAPI->getBody(),true);
            foreach ($resp["lines"] as $rawligne) {
                $directions = array();
                foreach ($rawligne["routes"] as $route) {
                    $directions[]=$route["name"];
                }
                if(is_int($rawligne["code"])){
                    if(substr($rawligne["code"],0,1)=="0")
                        $codeLigne = (int) $rawligne["code"];
                    else
                        $codeLigne = $rawligne["code"];
                }else{
                    $codeLigne = $rawligne["code"];
                }
                $tableauLignes[]=array("value"=>$rawligne["id"],"texte"=>"Ligne ".str_pad($codeLigne, 2, '0', STR_PAD_LEFT)." : Directions ".implode(" <> ",$directions));
            }
            $nombrePages = ceil($resp["pagination"]["total_result"]/$resp["pagination"]["items_per_page"]);
            if(($nombrePages-1) != $currentPagenumber && is_numeric($nombrePages) && $nombrePages > 0){
                return $this->getSelectListeLigne(($currentPagenumber+1),$tableauLignes);
            }else{
                return $tableauLignes;
            }

        }catch (\Exception $e){
            //dump($e);
            throw new \Exception("Service non disponible");
        }
    }
    public function kronosRemoveSubscriber($id){

    }
    public function kronosAddSubscriber($id){

    }
    public function kronosAddSubscriberSubscription($id,$mode,$cible){

    }
}