<?php

namespace Actigraph\ModuleNavitiaIoBundle\Controller;

use Actigraph\ActipageBaseBundle\Controller\ActipageBaseController;
use Actigraph\ActipageBaseBundle\Services\ActipageService;
use Actigraph\ModuleNavitiaIoBundle\Services\NavitiaIoService;
use GuzzleHttp\Exception\RequestException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use GuzzleHttp;

class DefaultController extends ActipageBaseController
{
    public function traficReportPerturbationsAction(Request $request,$globalParams=null,$pageParams=null,ActipageService $actipageService ){
        /** @var NavitiaIoService $navitiaIo */
        $navitiaIo = $this->get("Actigraph\ModuleNavitiaIoBundle\Services\NavitiaIoService");
        $perturbations = $navitiaIo->getPerturbations();
        if($actipageService->hasExtend("ActigraphModuleNavitiaIoBundle_traficReportPerturbations_perturbations")) //Surcharge des perturbations si extend
            $perturbations = $actipageService->handleExtend("ActigraphModuleNavitiaIoBundle_traficReportPerturbations_perturbations",array($perturbations));

        $defaultSelectedLigne = $request->get("ligneExternalCode",false);

        if($actipageService->hasExtend("ActigraphModuleNavitiaIoBundle_traficReportPerturbations_defaultSelectedLigne")) //Surcharge de la valeur par défaut si extend
            $defaultSelectedLigne = $actipageService->handleExtend("ActigraphModuleNavitiaIoBundle_traficReportPerturbations_defaultSelectedLigne",array($perturbations,$defaultSelectedLigne));
        else if($defaultSelectedLigne == false){
            if(count($perturbations)>0){
                $defaultSelectedLigne = array_values($perturbations)[0]["ligne"]["id"];
            }
        }
        return $this->extendAndRender('@ActigraphModuleNavitiaIoBundle/Default/traficReportPerturbations.html.twig', array(
            "perturbations"=>$perturbations,
            "defaultSelectedLigne"=>$defaultSelectedLigne
        ),"navitiaIoTraficReportPerturbations",array($perturbations,$defaultSelectedLigne),$actipageService);
    }

    public function kronosFormInscriptionDesinscriptionAction(Request $request,$globalParams=null,$pageParams=null,ActipageService $actipageService){

        $data = array(
            "mail"=>"",
            "tel"=>"",
            "nom"=>"",
            "prenom"=>"",
            "typeNotif"=>"sms"
        );
        /** @var NavitiaIoService $navitiaIo */
        $navitiaIo = $this->get("Actigraph\ModuleNavitiaIoBundle\Services\NavitiaIoService");
        $lignes = $navitiaIo->getSelectListeLigne();


        return $this->extendAndRender('@ActigraphModuleNavitiaIoBundle/Default/kronosFormInscriptionDesinscription.html.twig', array(
            "data"=>$data,
            "lignes"=>$lignes
        ),"navitiaIoKronosFormInscriptionDesinscription",array(),$actipageService);
    }

    public function showPlugAndPlayAction(Request $request,$globalParams=null,$pageParams=null,ActipageService $actipageService)
    {
        /** @var NavitiaIoService $navitiaIo */
        $navitiaIo = $this->get("Actigraph\ModuleNavitiaIoBundle\Services\NavitiaIoService");
        $defaultConfig = $navitiaIo->getConfig();

        $token = $defaultConfig["PP"]["itineraireToken"];
        $url = $defaultConfig["PP"]["url"];
        $stringParamsUrl = '';

        if($globalParams == "itineraire"){
            //TODO securité XSS dans les parametres recuperer
            $queryFrom = $request->get("from",false);
            $queryTo = $request->get("to",false);
            $queryFromId = $request->get("from_id",false);
            $queryToId = $request->get("to_id",false);
            $querydatetime_represents = $request->get("datetime_represents",false);
            $queryhour = $request->get("hour",false);
            $queryminute = $request->get("minute",false);
            $querydate = $request->get("date",false);
            $querymodes = $request->get("modes",array());
            $querydrawdown_modes = $request->get("drawdown_modes",false);
            $querytraveler_type = $request->get("traveler_type",false);
            $querytype = $request->get("type",false);
            if($queryTo && $queryFrom){
                $extraParams = array(
                    "from"=>$queryFrom,
                    "to"=>$queryTo,
                );
                if($queryFromId)
                    $extraParams["from_id"]=$queryFromId;
                if($queryToId)
                    $extraParams["to_id"]=$queryToId;
                if($querydatetime_represents)
                    $extraParams["datetime_represents"]=$querydatetime_represents;
                if($queryhour)
                    $extraParams["hour"]=$queryhour;
                if($queryminute)
                    $extraParams["minute"]=$queryminute;
                if($querydate)
                    $extraParams["date"]=$querydate;
                if($querymodes)
                    $extraParams["modes"]=$querymodes;
                if($querydrawdown_modes)
                    $extraParams["drawdown_modes"]=$querydrawdown_modes;
                if($querytraveler_type)
                    $extraParams["traveler_type"]=$querytraveler_type;
                if($querymodes)
                    $extraParams["type"]=$querytype;
                $stringParamsUrl = "/journey/result/?".http_build_query($extraParams, '', '&');
            }
            if($actipageService->hasExtend("ActigraphModuleNavitiaIoBundle_showPlugAndPlay_itineraireParams"))
                $stringParamsUrl = $actipageService->handleExtend("ActigraphModuleNavitiaIoBundle_showPlugAndPlay_itineraireParams",array($stringParamsUrl));

        }else if($globalParams == "autourdemoi") {
            $token = $defaultConfig["PP"]["autourdemoiToken"];
            //Gestion des params de l'url ?
            $stringParamsUrl ="/proximity";
            if($actipageService->hasExtend("ActigraphModuleNavitiaIoBundle_showPlugAndPlay_autourdemoiParams"))
                $stringParamsUrl = $actipageService->handleExtend("ActigraphModuleNavitiaIoBundle_showPlugAndPlay_autourdemoiParams",array($stringParamsUrl));

        }else{
            $token = $defaultConfig["PP"]["horaireToken"];
            $stringParamsUrl ="/schedule";
            if($actipageService->hasExtend("ActigraphModuleNavitiaIoBundle_showPlugAndPlay_horairesParams"))
                $stringParamsUrl = $actipageService->handleExtend("ActigraphModuleNavitiaIoBundle_showPlugAndPlay_horairesParams",array($stringParamsUrl));

        }

        return $this->extendAndRender('@ActigraphModuleNavitiaIoBundle/Default/showPlugAndPlay.html.twig', array(
            "token"=>$token,
            "baseUrl"=>$url,
            "paramsUrl"=>$stringParamsUrl,
            "langue"=>"fr"//TODO regarder la langue current; si c'est dans la liste desl angues du module je l'utilise sinon je met la premiére
        ),"navitiaIoPlugAndPlay",array(),$actipageService);
    }

    /**
     * @Route("/module/navitiaio/autocomplete", name="navitiaio_autocomplete")
     */
    public function autocompleteAction(Request $request){
        //TODO passer dans le service afin de le rendre accessible ailleur si besoin
        $reponse = new JsonResponse();

        $searchString = $request->get("q",false);
        if($searchString){
            $client = new GuzzleHttp\Client();

            /** @var NavitiaIoService $navitiaIo */
            $navitiaIo = $this->get("Actigraph\ModuleNavitiaIoBundle\Services\NavitiaIoService");
            $defaultConfig = $navitiaIo->getConfig();
            try {
                $urlRequested = $defaultConfig["PP"]["url"]."/load/".$defaultConfig["PP"]["autocompletionToken"]."/ws/v1/places?q=".urlencode($searchString);
                $responseAPI = $client->get($urlRequested, array('timeout' => 2));
                if($responseAPI->getStatusCode() != 200)
                    throw new \Exception("Service non disponible");

                $json = json_decode($responseAPI->getBody(),true);
                $tmp = array();
                if(isset($json["places"]) && count($json["places"])>0){
                    foreach ($json["places"] as $place){
                        $type = "arret";
                        if(in_array($place["embedded_type"],array("administrative_region","poi")))
                            $type = "poi";
                        elseif ($place["embedded_type"] == "address")
                            $type = "adresse";
                        $rawObjectData = $place[$place["embedded_type"]];
                        $tmp[]=array(
                            "id"=>$place["id"],
                            "label"=>$place["name"],
                            "type"=>$type,
                            "coord"=>array(
                                "lat"=>$rawObjectData["coord"]["lat"],
                                "lng"=>$rawObjectData["coord"]["lon"],
                            ),
                        );
                    }
                }
                $responseData = array(
                    "status"=>"success",
                    "data"=>$tmp
                );
            }catch (\Exception $e) {
                $responseData = array(
                    "status"=>"error",
                    "message"=>$e->getMessage()
                );
            }
        }else{
            $responseData = array(
                "status"=>"error",
                "message"=>"Pas de recherche"
            );
        }

        $reponse->setData($responseData);
        return $reponse;
    }
}
