<?php

namespace CloudFileStorage;


class Filesystem implements AdapterFilesystem
{
    protected $adapter;

    public function __construct(AdapterFilesystem $adapter)
    {
        $this->adapter = $adapter;
    }
    public function getAdapter()
    {
        return $this->adapter;
    }

    public function listeObjets($path)
    {
        return $this->adapter->listeObjets($path);
    }

    public function getFile($path)
    {
        return $this->adapter->getFile($path);
    }

    public function exists($key)
    {
        return $this->adapter->exists($key);
    }

    public function deleteFile($key)
    {
        return $this->adapter->deleteFile($key);
    }

    public function deleteFiles(Array $arrayKeys)
    {
        return $this->adapter->deleteFiles($arrayKeys);
    }

    public function copyRemoteFile($key, $destinationKey)
    {
        return $this->adapter->copyRemoteFile($key, $destinationKey);
    }

    public function uploadLocalFile($path, $localPath)
    {
        return $this->adapter->uploadLocalFile($path,$localPath);
    }

    public function generateTemporyUrl($key, \DateTime $dateTimeExpiration, $method = "GET", $forceDownload=false)
    {
        return $this->adapter->generateTemporyUrl($key, $dateTimeExpiration, $method, $forceDownload);
    }

    public function createDir($key)
    {
        return $this->adapter->createDir($key);
    }

    public function moveDir($oldPath,$newPath)
    {
        return $this->adapter->moveDir($oldPath,$newPath);
    }

    public function deleteDir($key)
    {
        return $this->adapter->deleteDir($key);
    }

}