<?php

namespace CloudFileStorage;


class File implements AdapterFile
{
    protected $adapter;

    public function __construct(AdapterFile $adapter)
    {
        $this->adapter = $adapter;
    }
    public function getAdapter()
    {
        return $this->adapter;
    }

    public function download($localFileLocaltion)
    {
        $out = fopen($localFileLocaltion,"wb");
        if ($out == FALSE){
            print "Probléme ouverture de la cible<br>";
        }

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_FILE, $out);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_URL, $this->getPublicUrl());
        curl_exec($ch);
        curl_close($ch);
    }

    public function isDir()
    {
        return $this->adapter->isDir();
    }

    public function getPublicUrl()
    {
        return $this->adapter->getPublicUrl();
    }

    public function getKey()
    {
        return $this->adapter->getKey();
    }

    public function getSize()
    {
        return $this->adapter->getSize();
    }

    public function getSizeHumain()
    {
        $iPoids = $this->getSize();
        return intval( $iPoids / 1024 ) < 1 ? $iPoids.' Octets' : intval( $iPoids / 1024 ).' Ko';
    }

    public function getMimeType()
    {
        return $this->adapter->getMimeType();
    }

    public function getLastModified()
    {
        return $this->adapter->getLastModified();
    }

    public function getName($key)
    {
        return $this->adapter->getName();
    }

    public function getThumbObjet($retry=true)
    {
        return $this->adapter->getThumbObjet($retry);
    }
    public function getImageWidthHeight()
    {
        return $this->adapter->getImageWidthHeight();
    }

}