     CREATE TABLE ville (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, external_code VARCHAR(255) DEFAULT NULL, code_postal VARCHAR(10) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB;
     CREATE TABLE stop_area (id INT AUTO_INCREMENT NOT NULL, ville_id INT DEFAULT NULL, external_code VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, accessible_pmr TINYINT(1) NOT NULL, coord_lat DOUBLE PRECISION NOT NULL, coord_lng DOUBLE PRECISION NOT NULL, coord_edited TINYINT(1) NOT NULL, coord_angle INT NOT NULL, coord_width INT NOT NULL, mode_affichage VARCHAR(255) DEFAULT 'default' NOT NULL, INDEX IDX_3D72FF77A73F0036 (ville_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB;
     CREATE TABLE poi (id INT AUTO_INCREMENT NOT NULL, type_id INT NOT NULL, ville_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, external_code VARCHAR(255) DEFAULT NULL, extra_data LONGTEXT DEFAULT NULL COMMENT '(DC2Type:array)', coord_lat DOUBLE PRECISION NOT NULL, coord_lng DOUBLE PRECISION NOT NULL, coord_edited TINYINT(1) NOT NULL, coord_angle INT NOT NULL, coord_width INT NOT NULL, mode_affichage VARCHAR(255) DEFAULT 'default' NOT NULL, INDEX IDX_7DBB1FD6C54C8C93 (type_id), INDEX IDX_7DBB1FD6A73F0036 (ville_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB;
     CREATE TABLE panneau (id INT AUTO_INCREMENT NOT NULL, file_name VARCHAR(255) NOT NULL, mode_affichage VARCHAR(255) NOT NULL, coord_lat DOUBLE PRECISION NOT NULL, coord_lng DOUBLE PRECISION NOT NULL, coord_edited TINYINT(1) NOT NULL, coord_angle INT NOT NULL, coord_width INT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB;
     CREATE TABLE ligne_direction (id INT AUTO_INCREMENT NOT NULL, ligne_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_F1AFDE3B5A438E76 (ligne_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB;
     CREATE TABLE ligne (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, external_code VARCHAR(255) NOT NULL, mode_affichage VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB;
     CREATE TABLE poi_type (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, external_code VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB;
     ALTER TABLE stop_area ADD CONSTRAINT FK_3D72FF77A73F0036 FOREIGN KEY (ville_id) REFERENCES ville (id);
     ALTER TABLE poi ADD CONSTRAINT FK_7DBB1FD6C54C8C93 FOREIGN KEY (type_id) REFERENCES poi_type (id);
     ALTER TABLE poi ADD CONSTRAINT FK_7DBB1FD6A73F0036 FOREIGN KEY (ville_id) REFERENCES ville (id);
     ALTER TABLE ligne_direction ADD CONSTRAINT FK_F1AFDE3B5A438E76 FOREIGN KEY (ligne_id) REFERENCES ligne (id);

ALTER TABLE `ligne` CHANGE COLUMN `mode_affichage` `mode_affichage` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default'  COMMENT '' AFTER `external_code`;
ALTER TABLE `panneau` CHANGE COLUMN `mode_affichage` `mode_affichage` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default'  COMMENT '' AFTER `file_name`;
