import {PanneauxRender} from "../../../../../assets/js/render/pois/panneauxrender"
import {BaseCarto} from "./basecarto"

const PANNEAUXRENDER = new PanneauxRender();

class Panneaux {
    static panneauxList: any[] = [];
    basecarto : BaseCarto;

    constructor(basecarto : BaseCarto) {
        this.basecarto = basecarto;
    }

    getPanneaux(panneauxId : number[]) {
        let vm = this
        panneauxId.forEach(function(element){
            vm.getPanneauxData(element);
        })
    }

    async getPanneauxData(id) {
        let panneauxListTmp = [];
        try {
            let layerConcerned = BaseCarto.configuration.panneauxLayer.find(function(e){ return e.id === id });
            let response = await fetch(BaseCarto.configuration.generateApiRoute(layerConcerned.apiRoute));
            let json = await response.json();
            json.forEach(function(element) {
                let panneauxStopRender = PANNEAUXRENDER.renderPanneaux(id, element).addTo(layerConcerned.layer);
                panneauxListTmp.push(panneauxStopRender)
            });

            Panneaux.panneauxList.push({id:layerConcerned.id, markerList:panneauxListTmp});

        }
        catch(e) {
            console.log('Error!', e);
        }
    }
}


export {Panneaux};