<?php

namespace Actigraph\CarteBundle\Service;

use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\DomCrawler\Crawler;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\Cache\ItemInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class InfoTrafficXmlService
{
    private $client;
    private $config;
    private $cache;

    public function __construct(HttpClientInterface $client, CacheInterface $cache, $config)
    {
        $this->client = $client;
        $this->config = $config;
        $this->cache = $cache;
    }

    public function getInfoTraffic($id)
    {
        $infoTraffics = $this->cache->get('get_traffic_'.$id, function (ItemInterface $item) use ($id) {
            $url = $this->config['gtfs']['urlInfoTraffic'];
            $response = $this->client->request('GET', $url);
            if ($response->getStatusCode() != 200) {
                return 'Problem with URL';
            }
            $infoTraffics = [];

            $xml = new \DOMDocument();
            $xml->loadXML($response->getContent());
            $xmlStatusCode = $xml->getElementsByTagName('StatusCode')->item(0)->textContent;
            if ($xmlStatusCode != 200) {
                return 'Problem with XML';
            }
            /** @var \DOMElement $disruption */
            foreach ($xml->getElementsByTagName('Disruption') as $disruption) {
                $persist = false;
                foreach ($disruption->getElementsByTagName('DisruptedLine') as $line) {
                    $lineId = $line->getElementsByTagName('LineId')->item(0)->textContent;
                    if ($lineId == $id) {
                        $persist = true;
                    }
                }
                if ($persist) {
                    $content = $disruption->getElementsByTagName('Description')->item(0)->textContent;
                    $htmlContent = new Crawler($content);
                    foreach ($htmlContent->filter('img') as $image) {
                        /** @var \DOMAttr $attr */
                        foreach ($image->attributes as $attr) {
                            if ($attr->nodeName == 'src') {
                                $attr->value = 'https://www.tam-voyages.com'. $attr->value;
                            }
                        }
                    }
                    $startAt = $disruption->getElementsByTagName('BeginValidityDateString')->item(0)->textContent;
                    $endAt = $disruption->getElementsByTagName('EndValidityDateString')->item(0)->textContent;
                    preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}/', $startAt, $startAtFormatted);
                    preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}/', $endAt, $endAtFormatted);
                    $infoTraffics[] = [
                        'content' => $htmlContent->html(),
                        'startAt' => implode('', $startAtFormatted),
                        'endAt' => implode('', $endAtFormatted),
                        'title' => $disruption->getElementsByTagName('Name')->item(0)->textContent,
                    ];
                }
            }

            $item->expiresAfter(1800);

            return $infoTraffics;
        });

        return $infoTraffics;
    }
}
