<?php


namespace Actigraph\CarteBundle\Service\BackObj;


use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemoteVille implements ObjectWithBackObj
{

    /** @var string $externalCode */
    private $externalCode="";

    /** @var string $name */
    private $name="";

    /** @var string $codePostal */
    private $codePostal="";

    /** @var float $lat */
    private $lat="";

    /** @var float $lng */
    private $lng="";

    /**
     * @return string
     */
    public function getExternalCode(): string
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode(string $externalCode): void
    {
        $this->externalCode = $externalCode;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getCodePostal(): string
    {
        return $this->codePostal;
    }

    /**
     * @param string $codePostal
     */
    public function setCodePostal(string $codePostal): void
    {
        $this->codePostal = $codePostal;
    }

    /**
     * @return float
     */
    public function getLat(): float
    {
        return $this->lat;
    }

    /**
     * @param float $lat
     */
    public function setLat(float $lat): void
    {
        $this->lat = $lat;
    }

    /**
     * @return float
     */
    public function getLng(): float
    {
        return $this->lng;
    }

    /**
     * @param float $lng
     */
    public function setLng(float $lng): void
    {
        $this->lng = $lng;
    }

    public function toArray(){
        return [
            "name"=>$this->getName(),
            "externalCode"=>$this->getExternalCode(),
            "coord"=>[
                "lat"=>$this->getLat(),
                "lng"=>$this->getLng()
            ]
        ];
    }
}