<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 16/10/2019
 * Time: 14:29
 */

namespace Actigraph\CarteBundle\Entity;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class LigneType implements ObjectWithBackObj
{


    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $typeLibelle;

    /**
     * @ORM\Column(type="integer")
     */
    private $ordre;


    /**
     * @ORM\OneToMany(targetEntity="Actigraph\CarteBundle\Entity\Ligne", mappedBy="type")
     */
    private $ligne;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getOrdre()
    {
        return $this->ordre;
    }

    /**
     * @param mixed $ordre
     */
    public function setOrdre($ordre)
    {
        $this->ordre = $ordre;
    }

    /**
     * @return mixed
     */
    public function getTypeLibelle()
    {
        return $this->typeLibelle;
    }

    /**
     * @param mixed $typeLibelle
     */
    public function setTypeLibelle($typeLibelle)
    {
        $this->typeLibelle = $typeLibelle;
    }

    /**
     * @return mixed
     */
    public function getLigne()
    {
        return $this->ligne;
    }

    /**
     * @param mixed $ligne
     */
    public function setLigne($ligne)
    {
        $this->ligne = $ligne;
    }

    public function toArray()
    {
        return [
            "id"=>$this->getId(),
            "libelle"=>$this->getTypeLibelle(),
        ];
    }

}