import * as $ from "jquery"
import * as d3 from "d3"
import {Linerender} from "../../../../../assets/js/render/pois/linerender"
import {BaseCarto} from "./basecarto";
import {Networkstop} from "./networkstop";
import {Iti} from "./iti";


class StyleGestion {
    static showOnlyLine = [];
    static additionaleGeojson : any = [];
    basecarto : BaseCarto;
    LINERENDER : Linerender;

    constructor(basecarto : BaseCarto) {
        this.LINERENDER = new Linerender(basecarto);
        this.basecarto = basecarto;
    }

    getStyle(section, lines){
        let properties = section.properties;
        if(typeof lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "undefined" && lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "" ){
            properties = Object.assign(JSON.parse(lines[BaseCarto.configuration.lineprefix+""+properties.ligneId].params),properties);
        }

        let isImportant = this.isLineImportant(properties.code_ligne);

        if(!isImportant)
            return 'stroke:white;stroke-width:0px;fill: none;opacity:0';
        if(properties.fleche != undefined) {
            return "stroke:black;stroke-width:0px;fill:black;";
        } else {
            let niveau = this.getLinesNiveauFromZoom(BaseCarto.map.getZoom());
            let epaisseur = this.getWeightLine(properties.epaisseur_ligne,niveau);
            let dashArray = null;
            let lineCap = null;
            let lineJoin = null;
            if (properties.pointille_ligne == "dash")
                dashArray = this.getWeightDash(niveau);
            if (properties.pointille_ligne == "dot")
                dashArray = this.getWeightDot(niveau);
            if(properties.lineJoin != undefined)
                lineJoin = properties.lineJoin;
            else if(BaseCarto.configuration.lineJoin != undefined)
                lineJoin = BaseCarto.configuration.lineJoin;
            else
                lineJoin = "round";
            if(properties.lineCap != undefined)
                lineCap = properties.lineCap;
            else if(BaseCarto.configuration.lineCap != undefined)
                lineCap = BaseCarto.configuration.lineCap;
            else
                lineCap = "round";
            let styleresponse =  'pointer-events: auto; stroke:'+properties.couleur_ligne+';stroke-width: '+epaisseur+'px;fill:none;stroke-linejoin:'+lineJoin+';stroke-linecap:'+lineCap+';';
            if(properties.pointille_ligne == "dash" || properties.pointille_ligne == "dot" )
                styleresponse +="stroke-dasharray:"+dashArray+";";
            if(properties.opacity != undefined )
                styleresponse += "opacity:"+properties.opacity+";";
            return styleresponse;
        }
    }

    getBorderStyle(section, lines){
        let properties = section.properties;
        if(typeof lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "undefined" && lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "" ){
            properties = Object.assign(JSON.parse(lines[BaseCarto.configuration.lineprefix+""+properties.ligneId].params),properties);
        }
        let isImportant = this.isLineImportant(properties.code_ligne);
        if(!isImportant)
            return 'stroke:white;stroke-width:0px;fill: none;opacity:0';
        let niveau = this.getLinesNiveauFromZoom(BaseCarto.map.getZoom());
        let epaisseur = this.getWeightLine(properties.epaisseur_ligne,niveau);
        epaisseur = this.borderEpaisseur(epaisseur);
        let dashArray = null;
        if (properties.pointille_border != undefined && properties.pointille_border == "true"){
            if (properties.pointille_ligne == "dash")
                dashArray = this.getWeightDash(niveau);
            if (properties.pointille_ligne == "dot")
                dashArray = this.getWeightDot(niveau);
        }
        let lineJoin;
        if(properties.borderLineJoin != undefined)
            lineJoin = properties.borderLineJoin;
        else if(BaseCarto.configuration.borderLineJoin != undefined)
            lineJoin = BaseCarto.configuration.borderLineJoin;
        else
            lineJoin = "round";
        let lineCap;
        if(properties.borderLineCap != undefined)
            lineCap = properties.borderLineCap;
        else if(BaseCarto.configuration.borderLineCap != undefined)
            lineCap = BaseCarto.configuration.borderLineCap;
        else
            lineCap = "butt";
        let styleresponse = "pointer-events: auto;stroke:"+properties.couleur_border+";stroke-width: "+epaisseur+"px;fill:none;stroke-linejoin:"+lineJoin+";stroke-linecap:"+lineCap+";";
        if(properties.pointille_ligne == "dash" || properties.pointille_ligne == "dot" )
            styleresponse +="stroke-dasharray:"+dashArray+";";
        if(properties.opacity != undefined )
            styleresponse += "opacity:"+properties.opacity+";";

        return styleresponse;
    }

    borderEpaisseur(epaisseur) {
        return epaisseur + ((1 / 3) * epaisseur);
    }

    linesCanHaveBorder() {
        if(BaseCarto.map.getZoom()>15 || BaseCarto.configuration.lineBackgroundAlwaysShow)
            return true;

        return false;
    }

    getWeightDot(niveau) {
        let zoomValue = BaseCarto.configuration.epaisseurDot;
        return zoomValue[niveau];
    }

    getWeightDash(niveau){
        let zoomValue = BaseCarto.configuration.epaisseurDash;
        return zoomValue[niveau];
    }

    getWeightLine(weightLine, zoom) {
        let zoomValue = BaseCarto.configuration.epaisseurLignes;
        let epaisseur;
        let multiplicator = 1;
        if(Iti.itiSelected)
            multiplicator = 2;
        switch (weightLine) {
            case "bold":
                epaisseur = BaseCarto.configuration.epaisseurType.bold * multiplicator;
                break;
            case "normal":
                epaisseur = BaseCarto.configuration.epaisseurType.normal * multiplicator;
                break;
            default:
                epaisseur = BaseCarto.configuration.epaisseurType.thin * multiplicator;
                break;
        }

        return epaisseur * zoomValue[zoom];

    }

    getLinesNiveauFromZoom(zoom){
        if (zoom <= 13) {
            return 1;
        } else if (zoom > 13 && zoom <= 15) {
            return 2;
        } else if (zoom== 16) {
            return 3;
        } else if (zoom == 17) {
            return 4;
        } else  if (zoom >= 18) {
            return 5
        }

        return zoom;
    }

    isLineImportant(externalCode){
        let isImportant = false;
        if(StyleGestion.showOnlyLine.length > 0){
            for(let i=0; i < StyleGestion.showOnlyLine.length ; i++){
                if(StyleGestion.showOnlyLine[i] == externalCode)
                    isImportant = true;
            }
        }else{
            if(Networkstop.isItiStopArea){
                return false;
            } else {
                let zoomsImportants = BaseCarto.configuration.importantLinesZoomLevel.split("-");
                if(parseInt(zoomsImportants[0]) <= BaseCarto.map.getZoom() && BaseCarto.map.getZoom() <= parseInt(zoomsImportants[1])) {
                    if(BaseCarto.configuration.importantLines.length > 0){
                        isImportant = false;
                        for (let i = 0; i < BaseCarto.configuration.importantLines.length; i++) {
                            if (BaseCarto.configuration.importantLines[i] == externalCode)
                                isImportant = true;
                        }
                    } else {
                        isImportant = true;
                    }

                }else
                    isImportant = true;
            }
        }

        return isImportant;
    }

    handleClick(e, tilelayer){
        let currentLigne = d3.select(e)._groups[0][0].__data__;
        let ligneId = d3.select(e)._groups[0][0].getAttribute("ligneId");
        let properties = JSON.parse(d3.select(e)._groups[0][0].getAttribute("props"));
        //let properties = currentLigne.properties;
        if(typeof tilelayer.lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "undefined" && tilelayer.lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "" ){
            properties = Object.assign(properties, JSON.parse(tilelayer.lines[BaseCarto.configuration.lineprefix+""+properties.ligneId].params));
        }
        currentLigne.properties = properties;

        let isImportant = this.isLineImportant(properties.code_ligne);
        if(!isImportant)
            return;

        let tmp1 = $(".leaflet-map-pane").css("-webkit-transform");
        if (tmp1 == null)
            tmp1 = $(".leaflet-map-pane").css("-ms-transform");
        if (tmp1 == null)
            tmp1 = $(".leaflet-map-pane").css("transform");

        let tmp2 = tmp1.split(",");
        let originX = 0;
        let originY = 0;
        if (tmp2.length > 1) {
            originX = parseInt(tmp2[4]);
            originY = parseInt(tmp2[5].substring(0, tmp2[5].length - 1));
        }

        let translateX = d3.event.pageX - originX + 45 + BaseCarto.configuration.PopUpPaddingsLines.left;
        let translateY = d3.event.pageY - originY + 35 + BaseCarto.configuration.PopUpPaddingsLines.top;

        let htmlContent = this.LINERENDER.clickRender(currentLigne, tilelayer);

        tilelayer.divPopUp.transition()
            .duration(200)
            .style("display", "block");
        tilelayer.divPopUp.html(htmlContent).attr("style", function () {
            let transformCss = 'transform:translate3d(' + translateX + 'px, ' + translateY + 'px, 0px);';
            return transformCss + 'bottom:27px;left:-136px';
        });

    }

    handleMouseOut(tilelayer){
        tilelayer.div.style("opacity", 0);
        tilelayer.div.style("display", "none");
    }

    handleMouseMove(e, tilelayer) {
        let currentLigne = d3.select(e)._groups[0][0].__data__;
        let ligneId = d3.select(e)._groups[0][0].getAttribute("ligneId");
        let properties = JSON.parse(d3.select(e)._groups[0][0].getAttribute("props"));
        if(typeof tilelayer.lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "undefined" && tilelayer.lines[BaseCarto.configuration.lineprefix+""+properties.ligneId] != "" ){
            properties = Object.assign(properties, JSON.parse(tilelayer.lines[BaseCarto.configuration.lineprefix+""+properties.ligneId].params));
        }
        currentLigne.properties = properties;
        let isImportant = this.isLineImportant(properties.code_ligne);
        if(!isImportant)
            return;
        let inficeFileName = properties.code_ligne.replace(/:/g, "_");
        let lineId = this.getLineId(inficeFileName, BaseCarto.configuration.separatorIndiceNamePlace);
        let identifiant = BaseCarto.configuration.lineprefixMask.replace("{id}", lineId);
        let lineConcerned = tilelayer.lines[BaseCarto.configuration.lineprefix+""+identifiant];
        if(typeof lineConcerned != "undefined") {
            let htmlContent = this.LINERENDER.mouseMoveRender(lineConcerned);

            tilelayer.div.html(htmlContent)
                .style("left", (d3.event.pageX + 10) + "px")
                .style("opacity", 1)
                .style("display", "block")
                .style("top", (d3.event.pageY - 15) + "px");
        }
    }

    handleMouseOver(e, tilelayer) {
        let currentLigne = d3.select(e)._groups[0][0].__data__;
        let ligneId = d3.select(e)._groups[0][0].getAttribute("ligneId");
        let properties = JSON.parse(d3.select(e)._groups[0][0].getAttribute("props"));
        if(typeof tilelayer.lines[BaseCarto.configuration.lineprefix+""+ligneId] != "undefined" && tilelayer.lines[BaseCarto.configuration.lineprefix+""+ligneId] != "" ){
            properties = Object.assign(properties, JSON.parse(tilelayer.lines[BaseCarto.configuration.lineprefix+""+ligneId].params));
        }
        currentLigne.properties = properties;
        let isImportant = this.isLineImportant(properties.code_ligne);
        if(!isImportant)
            return;
        let inficeFileName = properties.code_ligne.replace(/:/g, "_");
        let lineId = this.getLineId(inficeFileName, BaseCarto.configuration.separatorIndiceNamePlace);
        let identifiant = BaseCarto.configuration.lineprefixMask.replace("{id}", lineId);
        let lineConcerned = tilelayer.lines[BaseCarto.configuration.lineprefix+""+identifiant];
        if(typeof lineConcerned != "undefined") {
            let htmlContent = this.LINERENDER.mouseOverRender(lineConcerned);

            tilelayer.div.html(htmlContent)
                .style("left", (d3.event.pageX + 10) + "px")
                .style("opacity", 1)
                .style("display", "block")
                .style("top", (d3.event.pageY - 15) + "px");
        }
    }

    getLineId(linecode, separatorPlace){
        let codeArray = linecode.split("_");
        let tmpCode = codeArray[separatorPlace];
        let tmpCodeArray = tmpCode.split("-");

        return tmpCodeArray[0];
    }


}


export { StyleGestion };
