import {Poisrender} from "../../../../../assets/js/render/pois/poisrender"
import {BaseCarto} from "./basecarto"

const POISRENDER = new Poisrender();

class Pois  {
    static pois : any[] = [];
    static poisList: any[] = [];
    basecarto : BaseCarto;

    constructor(basecarto : BaseCarto){
        Pois.pois = BaseCarto.configuration.layersPoi ;
        this.basecarto = basecarto;
        let vm = this;
        let allPois = BaseCarto.configuration.layersPoi;
        allPois.forEach(function(element){
            if(element.needUpdate && element.interval > 0) {
                setInterval(async function () {
                    await vm.getPoisData(element.idPoiType);
                    BaseCarto.map.removeLayer(element.layer);
                    vm.basecarto.displayMarker("Pois");
                }, element.interval)
            }
        });
    }

    getPois(poisIds : number[]) {
        let vm = this;
        poisIds.forEach(async function(element) {
            await vm.getPoisData(element);
        })
    }

    async getPoisData(id) {
        let poisListTmp = [];
        try {
            let layerConcerned = BaseCarto.configuration.layersPoi.find(function(e) { return e.idPoiType === id });
            layerConcerned.layer.clearLayers();
            let response = await fetch(BaseCarto.configuration.generateApiRoute("referentiel_poibypoitype", {id:id}));
            let json = await response.json();
            json.forEach(function(element) {
                let poisMarker = POISRENDER.renderPoi(id, element).addTo(layerConcerned.layer);
                poisListTmp.push(poisMarker)
            });

            let poiListConcerned = Pois.poisList.find(function(e) { return e.id === layerConcerned.id });
            if(typeof poiListConcerned !== "undefined") {
                poiListConcerned.markerList = poisListTmp;
            } else {
                Pois.poisList.push({id:layerConcerned.id, markerList:poisListTmp})
            }
        }
        catch(e) {
            console.log('Error!', e);
        }
    }


}


export {Pois}