import {Networkstoprender} from "../../../../../assets/js/render/pois/networkstoprender"
import {BaseCarto} from "./basecarto"


const NETWORKSTOPRENDER = new Networkstoprender();

class Networkstop {
    static networkStopList: any[] = [];
    static networkStopListIti: any[] = [];
    static isItiStopArea = false;
    constructor(){}

    getNetworksStop(networkStopId : number[]) {
        let vm = this;
        networkStopId.forEach(function(element) {
            vm.getNetworksStopData(element);
        })
    }

    async getNetworksStopData(id) {
        let networkStopListTmp = [];
        Networkstop.networkStopList = [];
        try {
            let layerConcerned = BaseCarto.configuration.networkStopLayer.find(function(e) { return e.id === id });
            let response = await fetch(BaseCarto.configuration.generateApiRoute(layerConcerned.apiRoute));
            let json = await response.json();
            json.forEach(function(element) {
                let networkStopmarker = NETWORKSTOPRENDER.renderNetworkStop(id, element, 1).addTo(layerConcerned.layer);
                networkStopListTmp.push(networkStopmarker)
            });
            Networkstop.networkStopList.push({id:layerConcerned.id, markerList:networkStopListTmp})
        }
        catch(e) {
            console.log('Error!', e);
        }
    }

}


export {Networkstop}