import * as L from "leaflet"
import * as $ from "jquery"
import {BaseCarto} from "./basecarto"
import {Networkstop} from "./networkstop"
import {StyleGestion} from "./stylegestion"
import {Networkstoprender} from "../../../../../assets/js/render/pois/networkstoprender"

const NEWTWORKSTOPRENDER = new Networkstoprender();

const linesLayerItineraire = new L.LayerGroup();
const linesLayerBorderItineraire = new L.LayerGroup();

class Iti {
    arrivalPoint: any = {};
    departPoint: any = {};
    basecarto : BaseCarto;
    isStilPan: boolean = false;
    tooltip : L.tooltip;
    static itiSelected: boolean = false;
    constructor(basecarto : BaseCarto){
        this.basecarto = basecarto;
    }

    setDepartPoint(point) {
        this.removeDepartPoint();
        let departure = L.marker([point.coord.lat, point.coord.lng], {
            icon: L.icon({
                iconUrl: "/img/green-flag.gif",
                iconSize: [35, 50],
                iconAnchor: BaseCarto.configuration.iconAnchor
            })
        })
        .bindTooltip("<div class='label-marker'/> Départ </div>")
        .addTo(BaseCarto.map);
        BaseCarto.map.closePopup();
        this.departPoint = departure;
    }

    setArrivalPoint(point) {
        this.removeArrivalPoint();
        let arrival = L.marker([point.coord.lat, point.coord.lng], {
            icon: L.icon({
                iconUrl: "/img/red-flag.gif",
                iconSize: [35, 50],
                iconAnchor: BaseCarto.configuration.iconAnchor
            })
        })
        .bindTooltip("<div class='label-marker'/> Arrivée </div>")
        .addTo(BaseCarto.map);
        BaseCarto.map.closePopup();
        this.arrivalPoint = arrival;
    }

    setLocatePosition(location, render){

    }

    removeDepartPoint() {
        if (this.departPoint)
            BaseCarto.map.removeLayer(this.departPoint);
    }

    removeArrivalPoint() {
        if (this.arrivalPoint)
            BaseCarto.map.removeLayer(this.arrivalPoint);
    }

    displayItiStopArea(stopareas) {
        let networkStop = [];
        BaseCarto.configuration.networkStopLayer.forEach(function(element) {
            element.layer.clearLayers();
        });
        let layerConcerned = BaseCarto.configuration.networkStopLayer.find(function(e) { return e.id === 1 });
        stopareas.forEach(function(element) {
            let networkStopmarker = NEWTWORKSTOPRENDER.renderNetworkStop(1, element, 1).addTo(layerConcerned.layer);
            networkStop.push(networkStopmarker)
        });
        let networkStopToDisplay = [{id:layerConcerned.id, markerList:networkStop}];
        Networkstop.networkStopListIti = networkStopToDisplay;
        Networkstop.isItiStopArea = true;
        this.basecarto.displayMarker("networkStop");
    }
    
    removeItiStopArea() {
        let NETWORKSTOP = new Networkstop();
        if(Networkstop.isItiStopArea) {
            Networkstop.isItiStopArea = false;
            //NETWORKSTOP.getNetworksStop(BaseCarto.configuration.networkStopToDisplay);
            this.basecarto.displayMarker("networkStop");
        }
    }

    setGeoJsonOnMap(geojson) {
        this.removeGeojsonOnMap();
        StyleGestion.additionaleGeojson = geojson
    }

    addGeojsonOnMap(niveau, zoom = false) {
        StyleGestion.additionaleGeojson.forEach(function(geojson) {
            let epaisseur = BaseCarto.STYLEGESTION.getWeightLine(geojson.properties.epaisseur_ligne, niveau);
            let path = [{
                "type": geojson.type,
                "coordinates": geojson.coordinates
            }];
            let dashArray = "";
            let opacity = 1;
            L.geoJSON(path, {
                style: function (data) {
                    if (geojson.properties.pointille_ligne == "dash")
                        dashArray = BaseCarto.STYLEGESTION.getWeightDash(niveau);
                    if (geojson.properties.pointille_ligne == "dot")
                        dashArray = BaseCarto.STYLEGESTION.getWeightDot(niveau);
                    if(geojson.properties.opacity != undefined )
                        opacity =geojson.properties.opacity;

                    let color = "";
                    if(geojson.properties.opacity == undefined )
                        color = "#646464";
                    else
                        color = geojson.properties.couleur_ligne;

                    return {
                        color: color,
                        dashArray: dashArray,
                    };

                },

                weight: BaseCarto.STYLEGESTION.borderEpaisseur(epaisseur),
                opacity: opacity

            }).addTo(linesLayerItineraire);

            if(!BaseCarto.map.hasLayer(linesLayerItineraire)) {
                BaseCarto.map.addLayer(linesLayerItineraire);
            }

            L.geoJSON(path, {
                style: function (data) {
                    if (geojson.properties.pointille_border != undefined && geojson.properties.pointille_border == "true"){
                        if (geojson.properties.pointille_ligne == "dash")
                            dashArray = BaseCarto.STYLEGESTION.getWeightDash(niveau);
                        if (geojson.properties.pointille_ligne == "dot")
                            dashArray = BaseCarto.STYLEGESTION.getWeightDot(niveau);
                    }

                    let optionsStyleBorder = {
                        color: geojson.properties.couleur_border,
                        linecap: 'butt',
                        linejoin: 'miter',
                        dashArray: dashArray,
                        weight: BaseCarto.STYLEGESTION.borderEpaisseur(epaisseur),
                        opacity: 1

                    };
                    return optionsStyleBorder
                },

            }).addTo(linesLayerBorderItineraire);

            if(!BaseCarto.map.hasLayer(linesLayerBorderItineraire)) {
                BaseCarto.map.addLayer(linesLayerBorderItineraire);
            }

        });

        StyleGestion.additionaleGeojson = [];
    }

    removeGeojsonOnMap(){
        if(BaseCarto.map.hasLayer(linesLayerItineraire)){
            linesLayerItineraire.clearLayers();
            BaseCarto.map.removeLayer(linesLayerItineraire);

        }
        if(BaseCarto.map.hasLayer(linesLayerBorderItineraire)) {
            linesLayerBorderItineraire.clearLayers();

            BaseCarto.map.removeLayer(linesLayerBorderItineraire);
        }
    }

    focusOnDepartArrive(coord){
        let coords = new L.LatLng(coord.lat, coord.lng);
        BaseCarto.lineLayer.redraw();

        if($(window).width() > 767){
            let targetPoint = BaseCarto.map.project(coords, 17).subtract([$('.blocSEARCH').width() / 2, 0]),
                targetLatLng = BaseCarto.map.unproject(targetPoint, 17);

            BaseCarto.map.setView(targetLatLng, 17);
        } else {
            BaseCarto.map.setView(coords, 17, {padding:[500,500]});
        }
    }

    focusOnIti(){
        let depart = this.departPoint.getLatLng();

        if($(window).width() > 767){
            let targetPoint = BaseCarto.map.project(depart, 12).subtract([$('.blocSEARCH').width() / 2, 0]),
                targetLatLng = BaseCarto.map.unproject(targetPoint, 12);
            BaseCarto.map.setView(targetLatLng, 12);

        } else {
            BaseCarto.map.setView(depart, 12, {padding:[500,500]});
        }

    }

    focusOnItiBusVerts(){
        let depart = this.departPoint.getLatLng(),
            arrivee = this.arrivalPoint.getLatLng(),
            bounds = new L.LatLngBounds(depart, arrivee);

        let options = {padding: [10,10]};
        if(window.innerWidth > 767){
            options = {padding: [300,300]};
        }
        Iti.itiSelected = true;

        BaseCarto.map.fitBounds(bounds, options);
        BaseCarto.plan.setOpacity(0.6);
    }

    resetOpacity(){
        BaseCarto.plan.setOpacity(1);
    }

    focusOnDepart(){
        if(this.departPoint !== null && this.departPoint !== '') {
            let coord = this.departPoint.getLatLng();
            let tootlitp = L.tooltip()
                .setContent("<div class='label-marker'/>Départ</div>")
                .setLatLng(coord);
            this.tooltip = tootlitp;
            tootlitp.addTo(BaseCarto.map);
        }
    }

    focusOnArrivee(){
        if(this.arrivalPoint !== null && this.arrivalPoint !== '') {
            let coord = this.arrivalPoint.getLatLng();
            let tootlitp = L.tooltip()
                .setContent("<div class='label-marker'/>Arrivée</div>")
                .setLatLng(coord);
            this.tooltip = tootlitp;
            tootlitp.addTo(BaseCarto.map)
        }
    }

    destroyTooltip(){
        BaseCarto.map.closeTooltip(this.tooltip);
    }

    removeIti(){
        this.removeItiStopArea();
        this.removeGeojsonOnMap();
    }
}

export { Iti };
