import {BaseCarto} from "./basecarto"

class InfoTrafics {
    static infotraficList: any[] = [];

    constructor(){}

    async getInfotraficData() {
        try {
            let response = await fetch(BaseCarto.configuration.generateApiRoute("referentiel_infotrafic"));
            let json = await response.json();
            json.forEach(function(element) {
                let infoTraficData = {debut:element.debut, debutTS: element.debutTS, description:element.description, externalCode:element.description, fin:element.fin, finTS:element.finTS, name:element.name};
                element.lignes.forEach(function(el) {
                    let chekIfLigneExist = InfoTrafics.infotraficList.find(function(e) { return e.lineid === el.id });
                    let infoTraficLine = {lineid:el.id, linedata:el, infotrafic:[infoTraficData]};
                    if(chekIfLigneExist == null)
                        InfoTrafics.infotraficList.push(infoTraficLine);
                    else
                       chekIfLigneExist.infotrafic.push(infoTraficData);

                })
            });
            InfoTrafics.infotraficList.sort(this.compare)

        }
        catch(e) {
            console.log('Error!', e);
        }
    }

    compare(a, b) {
        const idA = a.lineid;
        const idB = b.lineid;
      
        let comparison = 0;
        if (idA > idB) {
          comparison = 1;
        } else if (idA < idB) {
          comparison = -1;
        }
        return comparison;
      }
      
}


export {InfoTrafics}