import * as $ from "jquery"
import {BaseCarto} from "../basecarto"

class MapAdmin {
    currentModifyData: any;
    currentModifyMarker: any;
    allModifyMarker: any;
    allModifySTOP: any;
    allModifyPOI: any;
    allModifyPANNEAU: any;
    mode : any;
    basecarto : BaseCarto;
    constructor(basecarto : BaseCarto) {
        this.currentModifyData = {};
        this.currentModifyMarker = {};
        this.allModifyMarker = [];
        this.allModifySTOP = [];
        this.allModifyPOI = [];
        this.allModifyPANNEAU = [];
        this.basecarto = basecarto;
    }

    addMapEventAdmin(){
        let vm = this;
        $("#save-modifs").on("click", function () {
            vm.saveAllModif();
            //vm.saveModifications()
        });

        $(".save-all").on("click", function () {
            vm.saveModifications();
            $(this).prop("disabled",true)
        });

        $(".addWidth").on("click", function () {
           vm.addWidth();
        });

        $(".reduireWidth").on("click", function () {
            vm.reduireWidth();
        });

        $('#rotationSliderContainer').on("degChange",function(event, data){
            vm.updateAngle(data.deg)
        });

        $('.save-poi').on("click", function () {
            vm.savePOI()
        });

        $('.edit-poi').on("click", function () {
            vm.editPOI()
        });

        $( "#poiType" ).on("change", function() {
            let type = 'type'+$(this).val()+'';
            vm.constructForm(type)
        });

        $(".modal").on("click", ".checkItem", function () {
            let mode = $(this).attr("data-mode");
            let elementConcerned: any;
            if(mode === "STOP")
                elementConcerned = vm.allModifySTOP.find(function(e){ return e.id === parseInt($(this).attr("data-id"))});
            if(mode === "POI")
                elementConcerned = vm.allModifyPOI.find(function(e){ return e.id === parseInt($(this).attr("data-id"))});
            if(mode === "PANNEAU")
                elementConcerned = vm.allModifyPANNEAU.find(function(e){ return e.id === parseInt($(this).attr("data-id"))});

            if($(this).is(':checked'))
                elementConcerned.save = true;
            else
                elementConcerned.save = false;
        });

        $("#modalAddPOI").on("hidden.bs.modal", function(){
            $(this).find('#formAddPoi')[0].reset();
        });

        $("#map-admin").on("click", ".deletePoi", function(){
            vm.deletePoi()
        });
        $("#map-admin").on("click", ".ModifyPoi", function(){
            vm.modifyDataPoi()
        });
    }

    updateAngle(angle){
        if(Object.entries(this.currentModifyMarker).length !== 0) {
            this.currentModifyMarker.options.angle = angle;
            this.currentModifyData.coord.angle = this.currentModifyMarker.options.angle;
            this.currentModifyMarker.update();

            this.saveModify()
        }

    }

    addWidth(){
        if(Object.entries(this.currentModifyMarker).length !== 0) {
            this.currentModifyMarker.options.largeur = this.currentModifyMarker.options.largeur + 5;
            this.currentModifyData.coord.width = this.currentModifyMarker.options.largeur;
            $("#widthActuel").html('').html('').append(this.currentModifyData.coord.width + "px");
            this.currentModifyMarker.update();

            this.saveModify()
        }

    }

    reduireWidth(){
        if(Object.entries(this.currentModifyMarker).length !== 0) {
            if(this.currentModifyData.coord.width != 0){
                this.currentModifyMarker.options.largeur = this.currentModifyMarker.options.largeur - 5;
                this.currentModifyData.coord.width = this.currentModifyMarker.options.largeur;
                $("#widthActuel").html('').html('').append(this.currentModifyData.coord.width +"px");

                this.currentModifyMarker.update();
            }

            this.saveModify()

        }

    }

    saveModifications(){
        let vm = this;
        $.post(BaseCarto.configuration.generateApiRoute("admin_savemarkermodif"), {modificationsSTOP:vm.allModifySTOP, modificationsPOI:vm.allModifyPOI, modificationsPANNEAU:vm.allModifyPANNEAU}, function (response) {
            if(response.success) {
                $("#modalSave").modal('hide');
                vm.allModifyMarker.forEach(function(e) {
                    e.options.isEdit = true;
                    if(e._icon !== null)
                        e.update()
                })
            }
            vm.disabelOldMarker(vm.currentModifyMarker);
            vm.reinitAllVariable();
            $(".save-all").prop("disabled",false)
        });
    }

    saveAllModif() {
        $("#modalSave").modal('show');
        $("#lis-modif").html("");
        this.allModifySTOP.forEach(function(element)  {
            $("#lis-modif").append('<li class="list-group-item"><input type="checkbox" class="form-check-input checkItem" id="item'+element.id+'" data-id="'+element.id+'" data-mode="STOP" checked>\n' +
                '<label class="form-check-label" for="item'+element.id+'">'+element.name+'</label></li>')
        });
        this.allModifyPOI.forEach(function(element) {
            $("#lis-modif").append('<li class="list-group-item"><input type="checkbox" class="form-check-input checkItem" id="item'+element.id+'" data-id="'+element.id+'" data-mode="POI" checked>\n' +
                '<label class="form-check-label" for="item'+element.id+'">'+element.name+'</label></li>')
        });
        this.allModifyPANNEAU.forEach(function(element) {
            $("#lis-modif").append('<li class="list-group-item"><input type="checkbox" class="form-check-input checkItem" id="item'+element.id+'" data-id="'+element.id+'" data-mode="PANNEAU" checked>\n' +
                '<label class="form-check-label" for="item'+element.id+'">Panneau</label></li>')
        });

    }

    saveModify() {
        let vm = this;
        if (this.mode === "STOP") {
            let checkIfExist = this.allModifySTOP.find(function(e){ return e.id === vm.currentModifyData.id});
            if (typeof checkIfExist === 'undefined') {
                this.allModifySTOP.push(this.currentModifyData);
                this.allModifyMarker.push(this.currentModifyMarker);
            }else {
                checkIfExist = this.currentModifyData;
            }
        }
        if (this.mode === "POI") {
            let checkIfExist = this.allModifyPOI.find(function(e){ return e.id === vm.currentModifyData.id });
            if (typeof checkIfExist === 'undefined')
                this.allModifyPOI.push(this.currentModifyData);
            else
                checkIfExist = this.currentModifyData;

        }
        if(this.mode === "PANNEAU"){
            let checkIfExist = this.allModifyPANNEAU.find(function(e){ return e.id === vm.currentModifyData.id});
            if(typeof checkIfExist === 'undefined')
                this.allModifyPANNEAU.push(this.currentModifyData);
            else
                checkIfExist = this.currentModifyData;
        }
    }

    setCurrentModify(marker, data, mode){
        this.setCurrentMarker(marker);
        this.currentModifyData = data;
        this.currentModifyData.save = true;
        this.mode = mode;
        if(mode === "STOP"){
            fetch(BaseCarto.configuration.generateApiRoute("referentiel_getstoplines", {stopId:data.externalCode})).then(function(response) {
                if(response.ok) {
                    response.json().then(function(resp) {
                        $("#lignesArret").html('');
                       resp.lignes.forEach(function(line) {
                           $("#lignesArret").append('<span class="col-sm-3 px-4  indice-'+line.id+'"><strong>'+line.shortName+'</strong></span>');
                       })
                    });
                }
            });
            $("#modif-stop").show();
            $("#arretName").html('').append(data.name);
            $("#lat").html('').append("Lat: "+data.coord.lat);
            $("#lng").html('').append("Lng: "+data.coord.lng);
            $("#rotationSliderDegrees").html('').html('').append(data.coord.angle+"°");
            $("#widthActuel").html('').append(data.coord.width +"px");
        }
        if(mode === "POI"){
            $("#modif-stop").hide();
            $("#arretName").html('').append(data.name);
            $("#lat").html('').html('').append("Lat: "+data.coord.lat);
            $("#lng").html('').html('').append("Lng: "+data.coord.lng);
        }
        if(mode === "PANNEAU"){
            $("#modif-stop").hide();
            $("#arretName").html('').append("Panneau");
            $("#lat").html('').html('').append("Lat: "+data.coord.lat);
            $("#lng").html('').html('').append("Lng: "+data.coord.lng);
        }
    }

    setCurrentMarker(marker){
        // On bloque le drag sur l'ancien marker
        this.disabelOldMarker(this.currentModifyMarker);
        this.currentModifyMarker = marker;
        // On autorise le drag sur le nouveau marker
        this.currentModifyMarker.dragging.enable();
    }

    disabelOldMarker(oldmarker){
        if(Object.entries(oldmarker).length !== 0 && typeof oldmarker.dragging !== "undefined")
            oldmarker.dragging.disable();
    }

    modifyMarkerPosition(){
        this.currentModifyData.coord.lat = this.currentModifyMarker.getLatLng().lat;
        this.currentModifyData.coord.lng = this.currentModifyMarker.getLatLng().lng;

        $("#lat").html('').html('').append(this.currentModifyData.coord.lat);
        $("#lng").html('').html('').append(this.currentModifyData.coord.lng);

        //this.currentModifyData.coord.angle = data.coord.angle;
    }

    reinitAllVariable(){
        this.currentModifyData = {};
        this.currentModifyMarker = {};
        this.allModifyMarker = [];
        this.allModifySTOP = [];
        this.allModifyPOI = [];
        this.allModifyPANNEAU = [];
    }

    addPOI(point){
        let val = "type"+$( "#poiType option:selected" ).val();
        $('div.extraData > div:not(.'+val+')').hide();
        $('div.extraData > div.'+val+'').show();
        $("#lat").val(point.latlng.lat);
        $("#lng").val(point.latlng.lng);
        $('.edit-poi').hide();
        $('.save-poi').show();
        $("#modalAddPOI").modal('show');
    }

    savePOI(){
        let val = "type"+$( "#poiType option:selected" ).val();
        let vm = this;
        let extraData = [];
        $('div.extraData > div.'+val+' > [name^="extraData"]').each(function() {
            let type = $(this).attr("data-type");
            extraData.push({type: type, val:$(this).val()});
        });

        let data = {
            type:$( "#poiType option:selected" ).val(),
            code:$( "#poiType option:selected" ).attr("data-code"),
            nom:$("#nom").val(),
            adresse:$("#adresse").val(),
            cp:$("#cp").val(),
            ville:$("#ville").val(),
            extraData : extraData,
            lng:$("#lng").val(),
            lat:$("#lat").val(),
        };
        $.post(BaseCarto.configuration.generateApiRoute("admin_savenewpoi"), {added:data}, function (response) {
            if(response.success) {
                alert("Le Poi a bien été créé");
                $("#modalAddPOI").modal('hide');
                vm.renewPoisData(parseInt(data.type));
                //BaseCarto.POIS.getPois(BaseCarto.configuration.poisToDisplay);
                //vm.basecarto.displayMarker("Pois");
                //this.basecarto.POIS.getPois(BaseCarto.configuration.poisToDisplay);
            }
        });

    }

    editPOI(){
        let vm = this;
        let val = "type"+$( "#poiType option:selected" ).val();
        let extraData = [];
        $('div.extraData > div.'+val+' > [name^="extraData"]').each(function() {
            let type = $(this).attr("data-type");
            extraData.push({type: type, val:$(this).val()});
        });
        let data = {
            type:$( "#poiType option:selected" ).val(),
            code:$( "#poiType option:selected" ).attr("data-code"),
            nom:$("#nom").val(),
            adresse:$("#adresse").val(),
            cp:$("#cp").val(),
            ville:$("#ville").val(),
            extraData : extraData,
        };

        $.post(BaseCarto.configuration.generateApiRoute("admin_editpoi", {id:this.currentModifyData.id}), {edit:data}, function (response) {
            if(response.success) {
                alert("Le Poi a bien été modifié");
                $("#modalAddPOI").modal('hide');
                vm.renewPoisData(parseInt(data.type));
                //BaseCarto.POIS.getPois(BaseCarto.configuration.poisToDisplay);
                //vm.basecarto.displayMarker("Pois");
                //this.basecarto.POIS.getPois(BaseCarto.configuration.poisToDisplay);
            }
        });
    }

    deletePoi(){
        let vm = this;
        $.post(BaseCarto.configuration.generateApiRoute("admin_deletepoi", {id:this.currentModifyData.id}), function (response) {
            if(response.success) {
                alert("Le Poi a bien été supprimé");
                vm.renewPoisData(parseInt(vm.currentModifyData.type.id));
                //BaseCarto.POIS.getPois(BaseCarto.configuration.poisToDisplay);
                //vm.basecarto.displayMarker("Pois");
                //this.basecarto.POIS.getPois(BaseCarto.configuration.poisToDisplay);
            }
        });
    }


    modifyDataPoi() {
        $.get(BaseCarto.configuration.generateApiRoute("admin_editpoi", {id:this.currentModifyData.id}), function (response) {
            if(response.success) {
                let type = response.data.type.id;
                $( "#poiType option[value='"+type+"']" ).prop("selected", true);
                $('div.extraData > div:not(.type'+type+')').hide();
                $('div.extraData > div.type'+type+'').show();
                $('#nom').val(response.data.name);
                $('#adresse').val(response.data.extraData.adresse);
                $('#ville').val(response.data.extraData.ville.name);
                $('#cp').val(response.data.extraData.ville.cp);
                Object.keys(response.data.extraData).forEach(function(key) {
                    if($('[name="extraData['+key+']"]').length){
                        $('[name="extraData['+key+']"]').val(response.data.extraData[key])
                    }
                });
                $('[name="extraData[code]"]').val(response.data.externalCode);
                $('.edit-poi').show();
                $('.save-poi').hide();
                $("#modalAddPOI").modal('show');

            }
        });
    }

    renewPoisData(type){
        let vm = this;
        let allPois = BaseCarto.configuration.layersPoi;
        allPois.forEach(async function(element){
            if(element.idPoiType === type){
                await BaseCarto.POIS.getPoisData(element.idPoiType);
                BaseCarto.map.removeLayer(element.layer);
                vm.basecarto.displayMarker("Pois");
            }
        });
    }

    constructForm(val){
        $('div.extraData > div:not(.'+val+')').hide();
        $('div.extraData > div.'+val+'').show();
    }
}

// Gestion de l'angle Plugin jQuery

(function ($) {


    var $container = $("#rotationSliderContainer");
    var $slider = $('#rotationSlider');
    var $degrees = $('#rotationSliderDegrees');

    var sliderWidth = $slider.width();
    var sliderHeight = $slider.height();
    var radius = $container.width() / 2;
    var deg = 0;

    var X = Math.round(radius * Math.sin(deg * Math.PI / 180));
    var Y = Math.round(radius * -Math.cos(deg * Math.PI / 180));
    $slider.css({
        left: X + radius - sliderWidth / 2,
        top: Y + radius - sliderHeight / 2
    });

    var mdown = false;
    $container
        .mousedown(function (e) {
            mdown = true;
            e.originalEvent.preventDefault();
        })
        .mouseup(function (e) {
            mdown = false;
        })
        .mousemove(function (e) {
            if (mdown) {

                // firefox compatibility
                if (typeof e.offsetX === "undefined" || typeof e.offsetY === "undefined") {
                    var targetOffset = $(e.target).offset();
                    e.offsetX = e.pageX - targetOffset.left;
                    e.offsetY = e.pageY - targetOffset.top;
                }

                if ($(e.target).is('#rotationSliderContainer'))
                    var mPos = {
                        x: e.offsetX,
                        y: e.offsetY
                    };
                else
                    var mPos = {
                        x: e.target.offsetLeft + e.offsetX,
                        y: e.target.offsetTop + e.offsetY
                    };

                var atan = Math.atan2(mPos.x - radius, mPos.y - radius);
                deg = -atan / (Math.PI / 180) + 180; // final (0-360 positive) degrees from mouse position


                // for attraction to multiple of 90 degrees
                var distance = Math.abs(deg - (Math.round(deg / 90) * 90));

                if (distance <= 5)
                    deg = Math.round(deg / 90) * 90;

                if (deg == 360)
                    deg = 0;

                var X = Math.round(radius * Math.sin(deg * Math.PI / 180));
                var Y = Math.round(radius * -Math.cos(deg * Math.PI / 180));

                $slider.css({
                    left: X + radius - sliderWidth / 2,
                    top: Y + radius - sliderHeight / 2
                });

                var roundDeg = Math.round(deg);

                $degrees.html(roundDeg + '&deg;');
                $('#imageRotateDegrees').val(roundDeg);
                $container.trigger("degChange", {deg:roundDeg});
            }
        });
    function setDeg (newDeg) {
        deg = newDeg;

        var X = Math.round(radius * Math.sin(deg * Math.PI / 180));
        var Y = Math.round(radius * -Math.cos(deg * Math.PI / 180));
        $slider.css({
            left: X + radius - sliderWidth / 2,
            top: Y + radius - sliderHeight / 2
        });
        $degrees.html(newDeg + '&deg;');
        $('#imageRotateDegrees').val(newDeg);
    };
    function getDeg () {
        return deg;
    };
    return {
        setDeg:setDeg
    };

})($);


export { MapAdmin };

