<?php

namespace Actigraph\CarteBundle\Service;

use App\Entity\Gtfs\Ligne;
use App\Entity\Gtfs\LigneSequence;
use App\Entity\Gtfs\Stop;
use App\Entity\Gtfs\StopLigne;
use Doctrine\ORM\EntityManagerInterface;
use Psr\Cache\InvalidArgumentException;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Cache\Adapter\TagAwareAdapter;
use Symfony\Contracts\Cache\CacheInterface;

class GtfsService
{
    private $entityManager;
    private $config;
    private $cache;

    public function __construct(EntityManagerInterface $entityManager, CacheInterface $cache, $config)
    {
        $this->entityManager = $entityManager;
        $this->config = $config;
        $this->cache = $cache;
    }

    public function getLignes()
    {
        $cacheKey = "back.gtfs.get-lignes";
        $lignes = [];
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $lignes;
        }

        if(!$cacheItem->isHit()){
            $lignes = $this->entityManager->getRepository(Ligne::class)->findAll();
            $cacheItem->set($lignes);
            $cacheItem->expiresAfter(3600);
            $this->cache->save($cacheItem);
        } else {
            $lignes = $cacheItem->get();
        }

        return $lignes;
    }

    public function getLignesWithArrets()
    {
        $cacheKey = "back.gtfs.get-lignes-with-arrets";
        $lignes = [];
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $lignes;
        }

        if(!$cacheItem->isHit()){
            $lignes = $this->entityManager->getRepository(Ligne::class)->getLignesWithArrets();
            $cacheItem->set($lignes);
            $cacheItem->expiresAfter(3600);
            $this->cache->save($cacheItem);
        } else {
            $lignes = $cacheItem->get();
        }

        return $lignes;
    }

    public function getLigneWithOrderedArrets($id, $direction)
    {
        $cacheKey = "back.gtfs.get-ligne-".$id."-with-ordered-arretss-".$direction;
        $ligne = '';
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $ligne;
        }

        if(!$cacheItem->isHit()){
            $result = $this->entityManager->getRepository(Ligne::class)->getLigneWithOrderedArrets($id, $direction);
            $ligne = $result[0] ?? [];
            $cacheItem->set($ligne);
            $cacheItem->expiresAfter(1);
            $this->cache->save($cacheItem);
        } else {
            $ligne = $cacheItem->get();
        }

        return $ligne;
    }

    public function getLigneWithAllDirections($id)
    {
        $cacheKey = "back.gtfs.get-ligne-".$id."-with-all-directions";
        $result = '';
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $result;
        }

        if(!$cacheItem->isHit()){
            $result = $this->entityManager->getRepository(Ligne::class)->getLigneWithAllDirections($id);
            $cacheItem->set($result);
            $cacheItem->expiresAfter(3600);
            $this->cache->save($cacheItem);
        } else {
            $result = $cacheItem->get();
        }

        return $result;
    }

    public function getAllArretsGroupby()
    {
        return $this->entityManager->getRepository(StopLigne::class)->getAllArretsGroupby();
    }

    public function getLogicalStops()
    {
//        $cacheKey = "back.gtfs.get-logical-stopss";
//        $result = [];
//        try {
//            $cacheItem = $this->cache->getItem($cacheKey);
//        } catch (InvalidArgumentException $e){
//            return $result;
//        }
//
//        if(!$cacheItem->isHit()){
        $result = $this->entityManager->getRepository(Stop::class)->getLogicalStops();

//            /** @var Stop $stopArea */
//            foreach ($result as $stopArea) {
//                $currentLogicalId = $stopArea->getId();
//                /** @var Stop $s */
//                $stops = $this->entityManager->getRepository(Stop::class)->findPhysicalStopsWithLignes($currentLogicalId);
//                $stopIds = [];
//                $ligneIds = [];
//                foreach ($stops as $s) {
//                    $stopIds[$s->getId()] = $s->getId();
////                    foreach ($s->getStopLignes() as $stopLigne) {
////                        $ligneIds[$stopLigne->getLigne()->getId()] = $stopLigne->getLigne();
////                    }
//                }
//                $stopArea->addComputedValue('physical_stops', $stopIds);
////                $stopArea->addComputedValue('linked_lignes', $ligneIds);
//            }

//            $cacheItem->set($result);
//            $cacheItem->expiresAfter(60);
//            $this->cache->save($cacheItem);
//        } else {
//            $result = $cacheItem->get();
//        }

        return $result;
    }

    public function getPhysicalStops()
    {
        $cacheKey = "back.gtfs.get-physical-stops";
        $result = [];
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $result;
        }

        if(!$cacheItem->isHit()){
            $result = $this->entityManager->getRepository(Stop::class)->getPhysicalStops();
            $cacheItem->set($result);
            $cacheItem->expiresAfter(3600);
            $this->cache->save($cacheItem);
        } else {
            $result = $cacheItem->get();
        }

        return $result;
    }

    public function syncStopAreas($id)
    {
        $cacheKey = "back.gtfs.sync-stopareas-by-ligne-".$id;
        $result = [];
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $result;
        }

        if(!$cacheItem->isHit()){
            $result = $this->entityManager->getRepository(Ligne::class)->syncStopAreas($id);
            $result = $result[0] ?? [];
            $cacheItem->set($result);
            $cacheItem->expiresAfter(3600);
            $this->cache->save($cacheItem);
        } else {
            $result = $cacheItem->get();
        }

        return $result;
    }
}
