<?php

namespace Actigraph\CarteBundle\Service\BackObj;
use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemoteStopTimeTable implements ObjectWithBackObj
{

    /** @var $stopareas */
    private $stopareas;

    /** @var $lignes */
    private $lignes;

    /** @var $timetable */
    private $timetable;

    /**
     * @return mixed
     */
    public function getTimetable()
    {
        return $this->timetable;
    }

    /**
     * @param mixed $stopareas
     */
    public function setTimetable($timetable): void
    {
        $this->timetable = $timetable;
    }

    /**
     * @return mixed
     */
    public function getStopareas()
    {
        return $this->stopareas;
    }

    /**
     * @param mixed $stopareas
     */
    public function setStopareas($stopareas): void
    {
        $this->stopareas = $stopareas;
    }

    /**
     * @return mixed
     */
    public function getLignes()
    {
        return $this->lignes;
    }

    /**
     * @param mixed $lignes
     */
    public function setLignes($lignes): void
    {
        $this->lignes = $lignes;
    }

    public function toArray(){
        if(is_null($this->getLignes()) || is_null($this->getStopareas()))
            return [];

        return [
            "stopareas"=>$this->getStopareas()->toArray(),
            "lignes"=>$this->getLignes()->toArray(),
            "timetable"=>$this->getTimetable()
        ];
    }

}


?>