<?php

namespace Actigraph\CarteBundle\Service\BackObj;
use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemoteStopLines implements ObjectWithBackObj
{
    /** @var $stopareas */
    private $stopareas;

    /** @var []ObjectWithBackObj $lignes */
    private $lignes;
    
    /** @var $nextDeparture */
    private $nextDeparture;

    /**
     * @return mixed
     */
    public function getStopareas()
    {
        return $this->stopareas;
    }

    /**
     * @param mixed $stopareas
     */
    public function setStopareas($stopareas): void
    {
        $this->stopareas = $stopareas;
    }

    /**
     * @return mixed
     */
    public function getLignes()
    {
        return $this->lignes;
    }

    /**
     * @param mixed $lignes
     */
    public function setLignes($lignes): void
    {
        $this->lignes = $lignes;
    }

    /**
     * @return mixed
     */
    public function getnextDeparture()
    {
        return $this->nextDeparture;
    }

    /**
     * @param mixed $nextDeparture
     */
    public function setnextDeparture($nextDeparture): void
    {
        $this->nextDeparture = $nextDeparture;
    }

    public function toArray(){
        $lignesData = [];
        if($this->getLignes() == null)
            return [];
        foreach ($this->getLignes() as $ligne){
            if($ligne != "")
                $lignesData[]=$ligne->toArray();
        }
        return [
            "stopareas"=>$this->getStopareas()->toArray(),
            "lignes"=>$lignesData,
            "nextDeparture"=>$this->getnextDeparture()
        ];
    }

}



?>