<?php


namespace Actigraph\CarteBundle\Service\BackObj;

use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemoteStopArea implements ObjectWithBackObj
{

    /** @var string $externalCode */
    private $externalCode="";

    /** @var string $name */
    private $name="";

    /** @var float $lat */
    private $lat="";

    /** @var float $lng */
    private $lng="";

    /** @var boolean $accessiblePmr */
    private $accessiblePmr=false;

    /** @var string $villeExternalCode */
    private $villeExternalCode="";

    /**
     * @return string
     */
    public function getExternalCode(): ?string
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode(string $externalCode): self
    {
        $this->externalCode = $externalCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return float
     */
    public function getCoordLat(): float
    {
        return $this->lat;
    }

    /**
     * @param float $lat
     */
    public function setCoordLat(float $lat): void
    {
        $this->lat = $lat;
    }

    /**
     * @return float
     */
    public function getCoordLng(): float
    {
        return $this->lng;
    }

    /**
     * @param float $lng
     */
    public function setCoordLng(float $lng): void
    {
        $this->lng = $lng;
    }

    /**
     * @return bool
     */
    public function isAccessiblePmr(): bool
    {
        return $this->accessiblePmr;
    }

    /**
     * @param bool $accessiblePmr
     */
    public function setAccessiblePmr(bool $accessiblePmr): void
    {
        $this->accessiblePmr = $accessiblePmr;
    }

    /**
     * @return string
     */
    public function getVilleExternalCode(): string
    {
        return $this->villeExternalCode;
    }

    /**
     * @param string $villeExternalCode
     */
    public function setVilleExternalCode(string $villeExternalCode): void
    {
        $this->villeExternalCode = $villeExternalCode;
    }

    public function toArray(){
        return [
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
            "accessible"=>$this->isAccessiblePmr(),
            "coord"=>[
                "lat"=>$this->getCoordLat(),
                "lng"=>$this->getCoordLng(),
            ],
            "ville"=>[
                "externalCode"=>$this->getVilleExternalCode()
            ]
        ];
    }

}