<?php


namespace Actigraph\CarteBundle\Service\BackObj;


use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemotePointItem implements ObjectWithBackObj
{
    public const TYPE_STOPAREA=0;
    public const TYPE_STOPPOINT=1;
    public const TYPE_POI=2;
    public const TYPE_MANUAL=3;
    public const TYPE_ADRESSE=4;

    /** @var string $name */
    private $name;
    /** @var string $externalCode */
    private $externalCode="";
    /** @var string $type */
    private $type;
    /** @var float $coordLat */
    private $coordLat;
    /** @var float $coordLng */
    private $coordLng;
    /** @var string $typeExtra */
    private $typeExtra="";

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {
        $this->type = $type;
    }

    /**
     * @return float
     */
    public function getCoordLat(): float
    {

        return $this->coordLat;
    }

    /**
     * @param float $coordLat
     */
    public function setCoordLat(float $coordLat): void
    {
        $this->coordLat = $coordLat;
    }

    /**
     * @return float
     */
    public function getCoordLng(): float
    {
        return $this->coordLng;
    }

    /**
     * @param float $coordLng
     */
    public function setCoordLng(float $coordLng): void
    {
        $this->coordLng = $coordLng;
    }

    /**
     * @return string
     */
    public function getTypeExtra(): string
    {
        return $this->typeExtra;
    }

    /**
     * @param string $typeExtra
     */
    public function setTypeExtra(string $typeExtra): void
    {
        $this->typeExtra = $typeExtra;
    }

    /**
     * @return string
     */
    public function getExternalCode(): string
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode(string $externalCode): void
    {
        $this->externalCode = $externalCode;
    }

    public function toArray(){
        return [
            "name"=>$this->getName(),
            "externalCode"=>$this->getExternalCode(),
            "type"=>$this->getType(),
            "typeExtra"=>$this->getTypeExtra(),
            "coord"=>[
                "lat"=>$this->getCoordLat(),
                "lng"=>$this->getCoordLng(),
            ],
        ];
    }
}