<?php


namespace Actigraph\CarteBundle\Service\BackObj;


use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemotePoi implements ObjectWithBackObj
{
    /** @var string $externalCode */
    private $externalCode="";

    /** @var string $name */
    private $name="";

    /** @var array $name */
    private $extraData = [];

    /** @var float $lat */
    private $lat="";

    /** @var float $lng */
    private $lng="";

    /**
     * @return string
     */
    public function getExternalCode(): string
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode(string $externalCode): void
    {
        $this->externalCode = $externalCode;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return array
     */
    public function getExtraData(): array
    {
        return $this->extraData;
    }

    /**
     * @param array $extraData
     */
    public function setExtraData(array $extraData): void
    {
        $this->extraData = $extraData;
    }

    /**
     * @return float
     */
    public function getLat(): float
    {
        return $this->lat;
    }

    /**
     * @param float $lat
     */
    public function setLat(float $lat): void
    {
        $this->lat = $lat;
    }

    /**
     * @return float
     */
    public function getLng(): float
    {
        return $this->lng;
    }

    /**
     * @param float $lng
     */
    public function setLng(float $lng): void
    {
        $this->lng = $lng;
    }

    public function toArray()
    {
        return [
            "name"=>$this->getName()
        ];
    }
}