<?php


namespace Actigraph\CarteBundle\Service\BackObj;


use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemoteLigneDirection implements ObjectWithBackObj
{
    /** @var string $externalCode */
    private $externalCode="";

    /** @var string $name */
    private $name="";

    /**
     * @return string
     */
    public function getExternalCode(): string
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode(string $externalCode): void
    {
        $this->externalCode = $externalCode;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function toArray()
    {
        return [
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
        ];
    }
}