<?php


namespace Actigraph\CarteBundle\Service\BackObj;


use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class Journey implements ObjectWithBackObj
{

    /** @var string $typeJourney */
    private $typeJourney ="";

    /** @var string $typePoints */
    private $typePoints ="";

    /** @var RemotePointItem $departPoint */
    private $departPoint ="";

    /** @var RemotePointItem $arriveePoint */
    private $arriveePoint ="";

    /** @var string $departDate */
    private $departDate ="";

    /** @var string $arriveeDate */
    private $arriveeDate ="";

    /** @var string $duree */
    private $duree ="";

    /** @var string $distance */
    private $distance ="";

    /** @var JourneyPerturbation[] $perturbations */
    private $perturbations=[];

    /** @var [] $sections */
    private $sections=[];

    /**
     * @return string
     */
    public function getTypeJourney()
    {
        return $this->typeJourney;
    }

    /**
     * @param string $typeJourney
     */
    public function setTypeJourney($typeJourney)
    {
        $this->typeJourney = $typeJourney;

        return $this;
    }

    /**
     * @return string
     */
    public function getTypePoints()
    {
        return $this->typePoints;
    }

    /**
     * @param string $typePoints
     */
    public function setTypePoints($typePoints)
    {
        $this->typePoints = $typePoints;

        return $this;

    }

    /**
     * @return RemotePointItem
     */
    public function getDepartPoint()
    {
        return $this->departPoint;
    }

    /**
     * @param RemotePointItem $departPoint
     */
    public function setDepartPoint($departPoint)
    {
        $this->departPoint = $departPoint;

        return $this;

    }

    /**
     * @return RemotePointItem
     */
    public function getArriveePoint()
    {
        return $this->arriveePoint;
    }

    /**
     * @param RemotePointItem $arriveePoint
     */
    public function setArriveePoint($arriveePoint)
    {
        $this->arriveePoint = $arriveePoint;

        return $this;

    }

    /**
     * @return string
     */
    public function getDepartDate()
    {
        return $this->departDate;
    }

    /**
     * @param string $departDate
     */
    public function setDepartDate($departDate)
    {
        $this->departDate = $departDate;
    }

    /**
     * @return string
     */
    public function getArriveeDate()
    {
        return $this->arriveeDate;
    }

    /**
     * @param string $arriveeDate
     */
    public function setArriveeDate($arriveeDate)
    {
        $this->arriveeDate = $arriveeDate;
    }

    /**
     * @return string
     */
    public function getDuree()
    {
        return $this->duree;
    }

    /**
     * @param string $duree
     */
    public function setDuree($duree)
    {
        $this->duree = $duree;

        return $this;

    }

    /**
     * @return JourneyPerturbation[]
     */
    public function getPerturbations()
    {
        return $this->perturbations;
    }

    /**
     * @param JourneyPerturbation[] $perturbations
     */
    public function setPerturbations($perturbations)
    {
        $this->perturbations = $perturbations;

        return $this;

    }

    /**
     * @return mixed
     */
    public function getSections()
    {
        return $this->sections;
    }

    /**
     * @param mixed $sections
     */
    public function setSections($sections)
    {
        $this->sections = $sections;

        return $this;

    }

    /**
     * @return string
     */
    public function getDistance()
    {
        return $this->distance;
    }

    /**
     * @param string $distance
     */
    public function setDistance($distance)
    {
        $this->distance = $distance;
    }

    public function toArray()
    {

        $sections = [];
        foreach ($this->getSections() as $section){
            $sections[] = $section->toArray();
        }
        $perturbations = [];

        foreach ($this->getPerturbations() as $perturbation){
            $perturbations[] = $perturbation->toArray();
        }


        return [
            "type"=>$this->getTypeJourney(),
            "typePoint"=>$this->getTypePoints(),
            "distance"=>$this->getDistance(),
            "depart"=>$this->getDepartPoint()->toArray(),
            "arrivee"=>$this->getArriveePoint()->toArray(),
            "departDate"=>$this->getDepartDate(),
            "arriveeDate"=>$this->getArriveeDate(),
            "duree"=>$this->getDuree(),
            "perturbations"=>$perturbations,
            "sections"=>$sections
        ];


    }

}