<?php


namespace Actigraph\CarteBundle\Service\Back;


use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Entity\Ligne;
use Actigraph\CarteBundle\Service\BackObj\RemoteInfoTrafic;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigne;
use Actigraph\CarteBundle\Service\BackObj\RemotePointItem;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopArea;
use Actigraph\CarteBundle\Service\BackObj\RemoteVille;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopLines;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopTimeTable;
use Actigraph\CarteBundle\Service\BackObj\RemoteLineTimeTable;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Validator\Constraints\Date;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigneDirection;
use Actigraph\CarteBundle\Service\BackObj\Journey;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepTransport;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepAttente;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepPied;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepBike;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepCar;
use Actigraph\CarteBundle\Service\BackObj\JourneyPerturbation;

use Actigraph\CarteBundle\Service\BackObj\JourneyStepTransfert;

class CitywayBack implements BackInterface, BackJourneyTransportCommun, BackJourneyTransportVelo, BackAutocomplete
{
    private $config;
    private $em;
    public function __construct(EntityManagerInterface $em, $backConfig)
    {
        $this->em = $em;
        $this->config = $backConfig;
    }

    /**
     * Recuperation des villes depuis le backoffice
     * @return RemoteVille[] Liste des viles distants
     */
    public function listVilles() : array {
        $listVilles = [];
        //TODO quand passage en symfony 4.3 remplacer par httpclient
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/stop/GetStops/json?OperatorIds=".$this->config["operatorId"]);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}

        curl_close($curl);
        $results =  json_decode($result, true);

        $IdAlreadyImported = [];

        if(isset($results["Data"]) && is_array($results["Data"])){
            foreach ($results["Data"] as $dataStoparea) {
                if(in_array($dataStoparea["Locality"]["Id"],$IdAlreadyImported)) //Si j'ai déja importé le stoparea du stoppoint alors je passe au suivant
                    continue;

                $currentVille = new RemoteVille();
                $currentVille->setExternalCode($dataStoparea["Locality"]["Id"]);
                $currentVille->setName($dataStoparea["Locality"]["Name"]);
                $currentVille->setLat($dataStoparea["Locality"]["Latitude"]);
                $currentVille->setLng($dataStoparea["Locality"]["Longitude"]);
                $currentVille->setCodePostal("");

                $listVilles[]=$currentVille;
                $IdAlreadyImported[]=$dataStoparea["Locality"]["Id"];
            }
        }
        return $listVilles;
    }

    /**
     * Recuperation des stoparea depuis le backoffice
     * @return RemoteStopArea[] Liste des arrêts distants
     */
    public function listStoparea() : array {
        $listStopArea = [];
        //TODO quand passage en symfony 4.3 remplacer par httpclient
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/stop/GetStops/json?OperatorIds=".$this->config["operatorId"]);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}

        curl_close($curl);
        $results =  json_decode($result, true);

        $logicalIdAlreadyImported = [];

        if(isset($results["Data"]) && is_array($results["Data"])){
            foreach ($results["Data"] as $dataStoparea) {
                if(in_array($dataStoparea["LogicalId"],$logicalIdAlreadyImported)) //Si j'ai déja importé le stoparea du stoppoint alors je passe au suivant
                    continue;

                $currentStop = new RemoteStopArea();
                $currentStop->setCoordLng($dataStoparea["Longitude"]);
                $currentStop->setCoordLat($dataStoparea["Latitude"]);
                $currentStop->setExternalCode($dataStoparea["LogicalId"]);
                $currentStop->setName($dataStoparea["Name"]);
                $isPmr = false;
                if(isset($dataStoparea["AccessibilityStatus"]) && is_array($dataStoparea["AccessibilityStatus"])){
                    if($dataStoparea["AccessibilityStatus"]["WheelChairAccess"]==2)
                        $isPmr=true;
                }
                $currentStop->setAccessiblePmr($isPmr);
                $currentStop->setVilleExternalCode($dataStoparea["Locality"]["Id"]);

                $listStopArea[]=$currentStop;
                $logicalIdAlreadyImported[]=$dataStoparea["LogicalId"];
            }
        }
        return $listStopArea;
    }

    public function listPoiByTypeExternalCode(string $typeExternalCode,array $extraParams) : array{
        print_r($typeExternalCode);
        print_r($extraParams);
        return [];
    }

    public function listLignes(): array{
        $listLignes = [];
        //TODO quand passage en symfony 4.3 remplacer par httpclient
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/line/GetLines/json?OnlyPublished=true&OperatorIds=".$this->config["operatorId"]);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}

        curl_close($curl);
        $results =  json_decode($result, true);
        if(isset($results["Data"]) && is_array($results["Data"])) {
            foreach ($results["Data"] as $dataLignes) {
                $directions = [];
                foreach ($dataLignes["LineDirections"] as $dir){
                    $dirObj = new RemoteLigneDirection();
                    $dirObj->setExternalCode($dataLignes["Id"]."_".$dir["Direction"]);
                    $dirObj->setName($dir["Name"]);
                    $directions[]=$dirObj;
                }
                $ligne = new RemoteLigne();
                $ligne->setExternalCode($dataLignes["Id"]);
                $ligne->setName($dataLignes["Name"]);
                $ligne->setShortName($dataLignes["Number"]);
                $ligne->setLigneBackgroundColor($dataLignes["Color"]);
                $ligne->setLigneTextColor($dataLignes["TextColor"]);
                $ligne->setDirections($directions);
                $listLignes[]=$ligne;
            }
        }
        return $listLignes;
    }

    public function listCurrentInfosTrafics($date=null): array{
        $listPerturbations = [];
        $now = new \DateTime();
        if ($date == '') {
            $date = (new \DateTime())->format('Y-m-d_H-i');
        }
        //TODO quand passage en symfony 4.3 remplacer par httpclient
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/events/v1/GetActualAndFutureDisruptions/json?&DateTime".$now->format("Y-m-d"));
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        if(isset($results["Data"]) && is_array($results["Data"])) {
            foreach ($results["Data"] as $dataPerturb) {
                if($dataPerturb["Source"]["Code"] == "TAN") {
                    $d = \DateTime::createFromFormat('d/m/Y H:i:s', $dataPerturb["BeginValidityDateString"])->getTimestamp();
                    $dRef = \DateTime::createFromFormat('Y-m-d_H-i', $date)->getTimestamp();
                    if ($d > $dRef) {
                        continue;
                    }
                    $perturb = new RemoteInfoTrafic();
                    $perturb->setExternalCode($dataPerturb["Id"]);
                    $perturb->setName($dataPerturb["Name"]);
                    $perturb->setDescription(nl2br($dataPerturb["Description"]));
                    $perturb->setDebut(\DateTime::createFromFormat('d/m/Y H:i:s', $dataPerturb["BeginValidityDateString"]));
                    $perturb->setFin(\DateTime::createFromFormat('d/m/Y H:i:s', $dataPerturb["EndValidityDateString"]));
                    $perturbLignes = [];
                    if (isset($dataPerturb["DisruptedLines"]) && is_array($dataPerturb["DisruptedLines"]) && count($dataPerturb["DisruptedLines"]) > 0) {
                        foreach ($dataPerturb["DisruptedLines"] as $ligneRaw) {
                            if (!isset($perturbLignes[$ligneRaw["LineId"]])) {
                                $ligne = new RemoteLigne();
                                $ligne->setExternalCode($ligneRaw["LineId"]);
                                $ligne->setDirections([]);
                                $perturbLignes[$ligneRaw["LineId"]] = $ligne;
                            }
                            $dir = new RemoteLigneDirection();
                            $dir->setExternalCode($ligne->getExternalCode() . "_" . $ligneRaw["Direction"]);

                            $perturbLignes[$ligneRaw["LineId"]]->addDirection($dir);
                        }
                    }
                    $perturb->setLignes($perturbLignes);
                    $listPerturbations[] = $perturb;
                }
            }
        }


        return $listPerturbations;
    }

    public function stopLines($text){
        $stopLine = new RemoteStopLines();
        $currentDate = date('Y-m-d_H-i');
        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/timetable/GetStopHours/json?LogicalStopIds=".$text."&DateTime=".$currentDate."&OperatorIds=".$this->config["operatorId"]);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);

        if(!$result){die("Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        if(isset($results["Data"]) && is_array($results["Data"])) {
            $timeForStops = [];
            $linesConcerned = [];
            $hoursConcerned = [];

            $hours = $results["Data"]["Hours"];
            foreach ($hours as $hour){
                $hours = null;
                if($hour["TheoricDepartureTime"] == null)
                    $hours = $hour["TheoricArrivalTime"];
                else
                    $hours = $hour["TheoricDepartureTime"];

                $hoursConcerned[$hour["StopId"]."_".$hour["LineId"]][] = $hours;
            }

            $lines = $results["Data"]["Lines"];
            $stops = $results["Data"]["Stops"];
            $linestops = $results["Data"]["LineStops"];
            foreach ($linestops as $stop) {
                $hour = null;
                $hour2 = null;
                if(isset($hoursConcerned[$stop["StopId"]."_".$stop["LineId"]])) {
                    $hour = $hoursConcerned[$stop["StopId"]."_".$stop["LineId"]][0];
                    if(isset($hoursConcerned[$stop["StopId"]."_".$stop["LineId"]][1])){
                        $hour2 = $hoursConcerned[$stop["StopId"]."_".$stop["LineId"]][1];
                    }
                }
                $nextDeparture = null;
                $nextDeparture2 = null;
                if($hour != null)
                    $nextDeparture = date('H:i', mktime(0, $hour));
                if($hour2 != null)
                    $nextDeparture2 = date('H:i', mktime(0, $hour2));

                $timeForStops[$stop["LineId"]."_".$stop["Direction"]] = [$nextDeparture, $nextDeparture2];
            }
            if(empty($stops)){
                return "";
            } else {
                $stopConcerned = $stops[0];
            }

            foreach ($lines as $line){
                if($line ["Company"]["Id"] == 3){
                    array_push($linesConcerned, $line);
                }
            }

            $currentStop = new RemoteStopArea();
            $currentStop->setCoordLng($stopConcerned["Longitude"]);
            $currentStop->setCoordLat($stopConcerned["Latitude"]);
            $currentStop->setExternalCode($stopConcerned["LogicalId"]);
            $currentStop->setName($stopConcerned["Name"]);
            $isPmr = false;
            if (isset($stopConcerned["AccessibilityStatus"]) && is_array($stopConcerned["AccessibilityStatus"])) {
                if ($stopConcerned["AccessibilityStatus"]["WheelChairAccess"] == 2)
                    $isPmr = true;
            }
            $currentStop->setAccessiblePmr($isPmr);
            $currentStop->setVilleExternalCode($stopConcerned["Locality"]["Id"]);
            $stopLine->setStopareas($currentStop);

            $allLignes = [];

            foreach ($linesConcerned as $line){
                $dir = new RemoteLigneDirection();
                $currentLine = new RemoteLigne();
                $currentLine->setExternalCode($line["Id"]);
                $currentLine->setDirections([]);
                foreach ($line["LineDirections"] as $direction) {
                    $dir->setExternalCode($currentLine->getExternalCode() . "_" . $direction["Direction"]);
                    $currentLine->addDirection($dir);
                }
                array_push($allLignes, $currentLine);

                $stopLine->setLignes($allLignes);

            }

            $stopLine->setnextDeparture($timeForStops);

        }

        return $stopLine;
    }

    public function getStopTimetable($stopId, $lineId, $direction, $date) {
        $stopTimeTable = new RemoteStopTimeTable();
        $tmpDate = explode("/", $date);
        $currentDate = $tmpDate[2]."-".$tmpDate[1]."-".$tmpDate[0];
        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/timetable/GetStopHours/json?LogicalStopIds=".$stopId."&DateTime=".$currentDate."&LineId=".$lineId."&Direction=".$direction."&OperatorIds=".$this->config["operatorId"]);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 10);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        if(isset($results["Data"]) && is_array($results["Data"])) {
            if($results["Data"] == null){
                return "";
            }
            $hoursConcerned = [];
            $timetable = [];
            $hours = $results["Data"]["Hours"];
            foreach ($hours as $hour){
                $hours = null;
                if($hour["TheoricDepartureTime"] == null)
                    $hours = $hour["TheoricArrivalTime"];
                else
                    $hours = $hour["TheoricDepartureTime"];

                if(in_array(date('H:i', mktime(0, $hours)), $hoursConcerned))
                    continue;

                $hoursConcerned[] = date('H:i', mktime(0, $hours));
            }

            foreach($hoursConcerned as $hour){
                $tmpHour = explode(':', $hour);
                $timetableTmp[sprintf("%02d", intval($tmpHour[0]))][] = sprintf("%02d", intval($tmpHour[1]));
            }

            // Pour ne pas perdre l'ordre des horaires lors de la récupéartion en JSON
            $count = 0;
            $max = 0;
            foreach($timetableTmp as $key => $time){
                if(count($time) > $max)
                    $max = count($time);
                $timetable["time"][$count]= array("hour"=>strval($key), "minutes"=>$time);
                $count++;
            }
            $timetable["maxelement"] = $max;
            $lines = $results["Data"]["Lines"];
            $stops = $results["Data"]["Stops"];
            if(empty($stops))
                return "";
            else
                $stopConcerned = $stops[0];

            if(empty($lines))
                return "";
            else
                $lineConcerned = $lines[0];

            $currentStop = new RemoteStopArea();
            $currentStop->setCoordLng($stopConcerned["Longitude"]);
            $currentStop->setCoordLat($stopConcerned["Latitude"]);
            $currentStop->setExternalCode($stopConcerned["LogicalId"]);
            $currentStop->setName($stopConcerned["Name"]);
            $isPmr = false;
            if (isset($stopConcerned["AccessibilityStatus"]) && is_array($stopConcerned["AccessibilityStatus"])) {
                if ($stopConcerned["AccessibilityStatus"]["WheelChairAccess"] == 2)
                    $isPmr = true;
            }
            $currentStop->setAccessiblePmr($isPmr);
            $currentStop->setVilleExternalCode($stopConcerned["Locality"]["Id"]);
            $stopTimeTable->setStopareas($currentStop);

            $dir = new RemoteLigneDirection();
            $currentLine = new RemoteLigne();
            $currentLine->setExternalCode($lineConcerned["Id"]);
            $currentLine->setDirections([]);
            foreach ($lineConcerned["LineDirections"] as $direction) {
                $dir->setExternalCode($currentLine->getExternalCode() . "_" . $direction["Direction"]);
                $currentLine->addDirection($dir);
            }

            $stopTimeTable->setLignes($currentLine);
            $stopTimeTable->setTimetable($timetable);
        }

        return $stopTimeTable;

    }

    public function getLineTimetable($lineid, $direction) {
        $lineTimeTable = new RemoteLineTimeTable();
        $currentDate = date('Y-m-d_H-i');
        $curl = curl_init();
        curl_reset($curl);
        //curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/stop/GetStopsByLine/json?LineId=".$lineid."&Direction=".$direction."&DateTime=".$currentDate."&OperatorIds=".$this->config["operatorId"]);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/stop/GetStopsByLine/json?LineId=".$lineid."&Direction=".$direction."&OperatorIds=".$this->config["operatorId"]);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 10);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        if(!$result){die("Get stop by lines : Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        $allStopsArray = array();

        if(isset($results["Data"]) && is_array($results["Data"])) {
            /*foreach($results["Data"] as $result){
                array_push($allStopsArray, $result["LogicalId"]);
            }*/

            $dir = new RemoteLigneDirection();
            $currentLine = new RemoteLigne();

            $allStopsLines = [];
            $timeForStops = [];

            $currentLine->setExternalCode($lineid);
            $currentLine->setDirections([]);
            $dir->setExternalCode($lineid."_".$direction);
            $currentLine->addDirection($dir);

            foreach($results["Data"] as $stopConcerned){

                $currentStop = new RemoteStopArea();
                $currentStop->setCoordLng($stopConcerned["Longitude"]);
                $currentStop->setCoordLat($stopConcerned["Latitude"]);
                $currentStop->setExternalCode($stopConcerned["LogicalId"]);
                $currentStop->setName($stopConcerned["Name"]);

                $isPmr = false;
                if (isset($stopConcerned["AccessibilityStatus"]) && is_array($stopConcerned["AccessibilityStatus"])) {
                    if ($stopConcerned["AccessibilityStatus"]["WheelChairAccess"] == 2)
                        $isPmr = true;
                }

                $currentStop->setAccessiblePmr($isPmr);
                $currentStop->setVilleExternalCode($stopConcerned["LocalityId"]);
                $timeForStops[] = array("stopId" => $stopConcerned["LogicalId"], "hours"=>[null]);

                array_push($allStopsLines, $currentStop);

            }

            $lineTimeTable->setnextDepartures($timeForStops);
            $lineTimeTable->setLigne($currentLine);
            $lineTimeTable->setStopareas($allStopsLines);

            //dump($results["Data"]);
            /*$allstops = implode("|",$allStopsArray);
            $currentDate = date('Y-m-d_H-i');
            $curl = curl_init();
            curl_reset($curl);
            curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/transport/v3/timetable/GetStopHours/json?LogicalStopIds=".$allstops."&DateTime=".$currentDate."&LineId=".$lineid."&Direction=".$direction."&MaxItemsByStop=2&OperatorIds=".$this->config["operatorId"]);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json'
            ));
            curl_setopt($curl, CURLOPT_TIMEOUT, 10);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            $resultStop = curl_exec($curl);
            if(!$resultStop){die("GetNextStopHours : Connection Failure");}
            curl_close($curl);
            $resultsStops =  json_decode($resultStop, true);
            //dump($resultsStops); exit;
            if(isset($resultsStops["Data"]) && is_array($resultsStops["Data"])){
                $dir = new RemoteLigneDirection();
                $currentLine = new RemoteLigne();

                $allStopsLines = [];
                $timeForStops = [];

                $line = $resultsStops["Data"]["Lines"][0];
                $currentLine->setExternalCode($line["Id"]);
                $currentLine->setDirections([]);
                foreach ($line["LineDirections"] as $direction) {
                    $dir->setExternalCode($currentLine->getExternalCode() . "_" . $direction["Direction"]);
                    $currentLine->addDirection($dir);
                }
                $hours = $resultsStops["Data"]["Hours"];
                foreach ($hours as $hour){
                    $hours = null;
                    if($hour["TheoricDepartureTime"] == null)
                        $hours = $hour["TheoricArrivalTime"];
                    else
                        $hours = $hour["TheoricDepartureTime"];

                    $hoursConcerned[$hour["StopId"]][] = $hours;
                }

                foreach($results["Data"] as $stopConcerned){
                    $currentStop = new RemoteStopArea();
                    $currentStop->setCoordLng($stopConcerned["Longitude"]);
                    $currentStop->setCoordLat($stopConcerned["Latitude"]);
                    $currentStop->setExternalCode($stopConcerned["LogicalId"]);
                    $currentStop->setName($stopConcerned["Name"]);
                    $isPmr = false;
                    if (isset($stopConcerned["AccessibilityStatus"]) && is_array($stopConcerned["AccessibilityStatus"])) {
                        if ($stopConcerned["AccessibilityStatus"]["WheelChairAccess"] == 2)
                            $isPmr = true;
                    }
                    $currentStop->setAccessiblePmr($isPmr);
                    $currentStop->setVilleExternalCode($stopConcerned["Locality"]["Id"]);

                    $hour = null;
                    if(isset($hoursConcerned[$stopConcerned["Id"]]))
                        $hour = $hoursConcerned[$stopConcerned["Id"]];

                    $nextDeparture = null;
                    if($hour != null){
                        foreach($hour as $h){
                            $nextDeparture[] = date('H:i', mktime(0, $h));
                        }
                    }
                    $timeForStops[] = array("stopId" => $stopConcerned["LogicalId"], "hours"=>$nextDeparture);
                    array_push($allStopsLines, $currentStop);
                }
                $lineTimeTable->setnextDepartures($timeForStops);
                $lineTimeTable->setLigne($currentLine);
                $lineTimeTable->setStopareas($allStopsLines);
            }*/

        }
        return $lineTimeTable;

    }

    private function extractDateTimeFromString($string){
        // /Date(1547442000000+0100)/
        $tmp = explode("(",$string);
        $tmp = explode("+",$tmp[1]);
        $stringTimestamp = substr($tmp[0],0,10);
        $date = new \DateTime();
        $date->setTimestamp($stringTimestamp);
        return $date;
    }

    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi{
        //Pas d'infos temps réel ou complémentaire en plus
        return $poi;
    }

    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array{
        //Pas d'infos temps réel ou complémentaire en plus
        return $this->listPoiByTypeExternalCode($typeExternalCode,$extraParams);
    }

    public function autocomplete($text): array
    {
        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/search/address?Keywords=".urlencode($text));
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        if(!$result){die("Autocomplete: Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        $allSuggestions = [];
        if(isset($results["Data"])){
            foreach ($results["Data"] as $suggest){
                 if (!isset($suggest["Locality"]["Id"]) || $suggest["Locality"]["Id"] < 43999 || $suggest["Locality"]["Id"] > 45000){
                     // Si a l'exterieur de la loire-atlantique on ignore
                    continue;
                }
                $city = "";
                if(isset($suggest["Locality"]) && isset($suggest["Locality"]["Name"])){
                        $city = " (".$suggest["Locality"]["Name"].")";
                }
                $streetnumber = "";
                if(isset($suggest["Number"]) && $suggest["Number"] > 0)
                    $streetnumber = $suggest["Number"]." ";
                $suggestion = new RemotePointItem();
                if($suggest["PointType"] == "4")
                    $suggestion->setType(RemotePointItem::TYPE_STOPAREA);
                elseif($suggest["PointType"] == "3")
                    $suggestion->setType(RemotePointItem::TYPE_ADRESSE);
                elseif($suggest["PointType"] == "1")
                    $suggestion->setType(RemotePointItem::TYPE_POI);
                else
                    $suggestion->setType(RemotePointItem::TYPE_MANUAL);

                $suggestion->setExternalCode($suggest["Id"]);
                $suggestion->setName($streetnumber.$suggest["Name"].$city);
                $suggestion->setCoordLat($suggest["Latitude"]);
                $suggestion->setCoordLng($suggest["Longitude"]);
                $allSuggestions[] = $suggestion;
            }
        }

        return $allSuggestions;
    }

    public function getJourneyTransportCommun($from,$to,$dateTime,$dateTimeRepresent, $extra, $infotrafics): array {
        $date = new \DateTime();
        $date = $date->format("Y-m-d_H-i");
        $datetype = "Departure";
        if($from["type"] == "0"){
            $departureString = "DepartureType=STOP_PLACE&DepartureId=".$from["externalCode"];
        }elseif ($from["type"] == "2"){
            $departureString = "DepartureType=COORDINATES&DepartureLatitude=".$from["coord"]["lat"]."&DepartureLongitude=".$from["coord"]["lng"];
        } else {
            $departureString = "DepartureType=COORDINATES&DepartureLatitude=".$from["coord"]["lat"]."&DepartureLongitude=".$from["coord"]["lng"];
        }
        if($extra["acccessibitlity"] == "true")
            $accesibility = "WheelChair";
        else
            $accesibility = "None";

        if($extra["perturbation"] == "true")
            $perturbation = "1";
        else
            $perturbation = "";

        if($to["type"] == "0"){
            $arriveeString = "ArrivalType=STOP_PLACE&ArrivalId=".$to["externalCode"];
        }elseif ($to["type"] == "2"){
            $arriveeString = "ArrivalType=COORDINATES&ArrivalLatitude=".$to["coord"]["lat"]."&ArrivalLongitude=".$to["coord"]["lng"];
        } else {
            $arriveeString = "ArrivalType=COORDINATES&ArrivalLatitude=".$to["coord"]["lat"]."&ArrivalLongitude=".$to["coord"]["lng"];
        }

        if($dateTimeRepresent != "now")
            $date = $dateTime;
        if($dateTimeRepresent == "after"){
            $datetype = "Arrival";
        }


        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/journeyplanner/api/opt/PlanTrips/json?".$departureString."&".$arriveeString."&Date=".$date."&DateType=".$datetype."&Algorithm=FASTEST&Accessibility=".$accesibility."&AvoidDisruptions=".$perturbation."&AllowedOperatorIds=2&UserId=TAN_WEB");
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        $allTrips = [];
        if(isset($results["Data"])) {
            $tripsArray = [];
            foreach ($results["Data"] as $dataJourney) {
                if (!empty($dataJourney["response"]["trips"]["Trip"])) {
                    foreach ($dataJourney["response"]["trips"]["Trip"] as $trip) {
                        array_push($tripsArray, $trip);
                    }
                }
            }

            if(!empty($tripsArray)){
                $allTrips = $this->getJourney($tripsArray, $infotrafics);
            }

        }
        return $allTrips;
    }

    public function getJourneyVelo($from,$to,$dateTime,$dateTimeRepresent, $extra){
        $dateTmp = new \DateTime();
        $date = $dateTmp->format("Y-m-d");
        $hour = $dateTmp->format("H-i");
        $dateType = "&DepartureTime=".$hour;
        if($from["type"] == "0"){
            $departureString = "DepType=STOP_PLACE&DepId=".$from["externalCode"];
        }elseif ($from["type"] == "2"){
            $departureString = "DepType=POI&DepId=".$from["externalCode"];
        } else {
            $departureString = "DepType=ADDRESS&DepLat=".$from["coord"]["lat"]."&DepLon=".$from["coord"]["lng"];
        }

        if($to["type"] == "0"){
            $arriveeString = "ArrType=STOP_PLACE&ArrId=".$to["externalCode"];
        }elseif ($to["type"] == "2"){
            $arriveeString = "ArrType=POI&ArrId=".$to["externalCode"];
        } else {
            $arriveeString = "ArrType=ADDRESS&ArrLat=".$to["coord"]["lat"]."&ArrLon=".$to["coord"]["lng"];
        }

        if($dateTimeRepresent != "now") {
            $dateTmp = explode("_",$dateTime);
            $date = $dateTmp[0];
            $hour = $dateTmp[1];
            $dateType = "&DepartureTime=".$hour;

        }

        if($dateTimeRepresent == "after"){
            $dateType = "&ArrivalTime=".$hour;
        }
        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/journeyplanner/v2/BikeTrip/json?".$departureString."&".$arriveeString."&Date=".$date."".$dateType);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);

        $allTrips = [];
        if(isset($results["trips"])){
            $tripsArray = [];

            foreach ($results["trips"]["Trip"] as $trip){
                array_push($tripsArray, $trip);
            }

            if(!empty($tripsArray)){
                $allTrips = $this->getTripBike($tripsArray);
            }

        }

        return $allTrips;

    }

    public function getJourneyVoiture($from,$to,$dateTime,$dateTimeRepresent, $extra){
        $dateTmp = new \DateTime();
        $date = $dateTmp->format("Y-m-d");
        $hour = $dateTmp->format("H-i");
        $dateType = "&DepartureTime=".$hour;
        if($from["type"] == "0"){
            $departureString = "DepType=STOP_PLACE&DepId=".$from["externalCode"];
        }elseif ($from["type"] == "2"){
            $departureString = "DepType=POI&DepId=".$from["externalCode"];
        } else {
            $departureString = "DepType=ADDRESS&DepLat=".$from["coord"]["lat"]."&DepLon=".$from["coord"]["lng"];
        }

        if($to["type"] == "0"){
            $arriveeString = "ArrType=STOP_PLACE&ArrId=".$to["externalCode"];
        }elseif ($to["type"] == "2"){
            $arriveeString = "ArrType=POI&ArrId=".$to["externalCode"];
        } else {
            $arriveeString = "ArrType=ADDRESS&ArrLat=".$to["coord"]["lat"]."&ArrLon=".$to["coord"]["lng"];
        }

        if($dateTimeRepresent != "now") {
            $dateTmp = explode("_",$dateTime);
            $date = $dateTmp[0];
            $hour = $dateTmp[1];
            $dateType = "&DepartureTime=".$hour;

        }

        if($dateTimeRepresent == "after"){
            $dateType = "&ArrivalTime=".$hour;
        }
        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/journeyplanner/v2/CarTrip/json?".$departureString."&".$arriveeString."&Date=".$date."".$dateType);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        $allTrips = [];
        if(isset($results["trips"])){
            $tripsArray = [];

            foreach ($results["trips"]["Trip"] as $trip){
                array_push($tripsArray, $trip);
            }

            if(!empty($tripsArray)){
                $allTrips = $this->getTripCar($tripsArray);
            }

        }


        return $allTrips;

    }

    public function getTripCar($journeyData){
        $allJourney = [];

        foreach ($journeyData as $trip){
            $journey = new Journey();
            $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["DepartureTime"]);
            $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["ArrivalTime"]);

            $journey->setDepartDate($startWait->getTimestamp());
            $journey->setArriveeDate($endWait->getTimestamp());

            $journey->setTypeJourney("CAR");

            $journey->setDepartPoint($this->GetPoint($trip["Departure"]["Site"]));
            $journey->setArriveePoint($this->GetPoint($trip["Arrival"]["Site"]));

            $journey->setDistance($trip["Distance"]);
            // Calcul de la durée du trajet
            $interval = new \DateInterval($trip["Duration"]);
            $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
            $journey->setDuree($duration);

            $sections = $trip["sections"]["Section"];

            $journey->setSections($this->getJourneySectionsCar($sections));

            array_push($allJourney, $journey);
        }

        return $allJourney;
    }

    public function getJourneySectionsCar($sectionData){
        $tripSections = [];
        foreach ($sectionData as $key => $section) {
            $sectionTrip = null;

            if (isset($section["PTRide"])) {
                $sectionTrip = $this->PTRideSection($section["PTRide"]);
            } else if (isset($section["Leg"])) {
                if($section["Leg"]["TransportMode"] == "PRIVATE_VEHICLE") {
                    $sectionTrip = $this->CarSection($section["Leg"]);
                } else {
                    $sectionTrip = $this->LegSection($section["Leg"]);
                }
            }
            array_push($tripSections, $sectionTrip);

        }


        return $tripSections;
    }

    public function CarSection($section){
        $carSection = new JourneyStepCar();

        $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $section["Departure"]["Time"]);
        $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $section["Arrival"]["Time"]);

        $carSection->setDepartDate($startWait->getTimestamp());
        $carSection->setArriveeDate($endWait->getTimestamp());

        $carSection->setDepartPoint($this->GetPoint($section["Departure"]["Site"]));
        $carSection->setArriveePoint($this->GetPoint($section["Arrival"]["Site"]));

        $interval = new \DateInterval($section["Duration"]);
        $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
        $carSection->setDuree($duration);

        $geoJson = $this->getaditionalGeoJson($section, "CAR");
        $carSection->setRoad($geoJson["additionalGeoJson"]);
        $carSection->setDistance($geoJson["distance"]);
        $carSection->setExtraData(array());


        return $carSection;
    }

    public function getTripBike($journeyData){
        $allJourney = [];

        foreach ($journeyData as $trip){
            $journey = new Journey();
            $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["DepartureTime"]);
            $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["ArrivalTime"]);

            $journey->setDepartDate($startWait->getTimestamp());
            $journey->setArriveeDate($endWait->getTimestamp());

            $journey->setTypeJourney("BIKE");

            $journey->setDepartPoint($this->GetPoint($trip["Departure"]["Site"]));
            $journey->setArriveePoint($this->GetPoint($trip["Arrival"]["Site"]));

            $journey->setDistance($trip["Distance"]);
            // Calcul de la durée du trajet
            $interval = new \DateInterval($trip["Duration"]);
            $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
            $journey->setDuree($duration);

            $sections = $trip["sections"]["Section"];

            $journey->setSections($this->getJourneySectionsBike($sections));

            array_push($allJourney, $journey);
        }

        return $allJourney;
    }

    public function getJourneySectionsBike($sectionData) {
        $tripSections = [];
        foreach ($sectionData as $key => $section) {
            $sectionTrip = null;

            if (isset($section["PTRide"])) {
                $sectionTrip = $this->PTRideSection($section["PTRide"]);
            } else if (isset($section["Leg"])) {
                if($section["Leg"]["TransportMode"] == "BICYCLE") {
                    $sectionTrip = $this->BikeSection($section["Leg"]);
                } else {
                    $sectionTrip = $this->LegSection($section["Leg"]);
                }
            }
            array_push($tripSections, $sectionTrip);

        }

        return $tripSections;
    }

    public function BikeSection($section) {
        $bikeSection = new JourneyStepBike();

        $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $section["Departure"]["Time"]);
        $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $section["Arrival"]["Time"]);

        $bikeSection->setDepartDate($startWait->getTimestamp());
        $bikeSection->setArriveeDate($endWait->getTimestamp());

        $bikeSection->setDepartPoint($this->GetPoint($section["Departure"]["Site"]));
        $bikeSection->setArriveePoint($this->GetPoint($section["Arrival"]["Site"]));

        $interval = new \DateInterval($section["Duration"]);
        $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
        $bikeSection->setDuree($duration);

        $geoJson = $this->getaditionalGeoJson($section, "BIKE");
        $bikeSection->setRoad($geoJson["additionalGeoJson"]);
        $bikeSection->setDistance($geoJson["distance"]);
        $bikeSection->setExtraData(array("voieBicycle"=>$geoJson["voieBicycle"], "voieBicycleDescription"=>$geoJson["voieBicycleDescription"]));


        return $bikeSection;

    }

    public function getJourneyWalk($from, $to, $dateTime, $datetimeRepresent, $extra)
    {
        $dateTmp = new \DateTime();
        $date = $dateTmp->format("Y-m-d");
        $hour = $dateTmp->format("H-i");
        $dateType = "&DepartureTime=".$hour;
        if($from["type"] == "0"){
            $departureString = "DepType=STOP_PLACE&DepId=".$from["externalCode"];
        }elseif ($from["type"] == "2"){
            $departureString = "DepType=POI&DepId=".$from["externalCode"];
        } else {
            $departureString = "DepType=ADDRESS&DepLat=".$from["coord"]["lat"]."&DepLon=".$from["coord"]["lng"];
        }

        if($to["type"] == "0"){
            $arriveeString = "ArrType=STOP_PLACE&ArrId=".$to["externalCode"];
        }elseif ($to["type"] == "2"){
            $arriveeString = "ArrType=POI&ArrId=".$to["externalCode"];
        } else {
            $arriveeString = "ArrType=ADDRESS&ArrLat=".$to["coord"]["lat"]."&ArrLon=".$to["coord"]["lng"];
        }

        if($datetimeRepresent != "now") {
            $dateTmp = explode("_",$dateTime);
            $date = $dateTmp[0];
            $hour = $dateTmp[1];
            $dateType = "&DepartureTime=".$hour;
        }

        if($datetimeRepresent == "after"){
            $dateType = "&ArrivalTime=".$hour;
        }
        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/api/journeyplanner/v2/WalkTrip/json?".$departureString."&".$arriveeString."&Date=".$date."".$dateType);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}
        curl_close($curl);
        $results =  json_decode($result, true);
        $allTrips = [];
        if(isset($results["trips"])){
            $tripsArray = [];
            foreach ($results["trips"]["Trip"] as $trip){
                array_push($tripsArray, $trip);
            }
            if(!empty($tripsArray)){
                $allTrips = $this->getTripWalk($tripsArray);
            }
        }

        return $allTrips;
    }

    public function getTripWalk($journeyData){
        $allJourney = [];
        foreach ($journeyData as $trip){
            $journey = new Journey();
            $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["DepartureTime"]);
            $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["ArrivalTime"]);

            $journey->setDepartDate($startWait->getTimestamp());
            $journey->setArriveeDate($endWait->getTimestamp());
            $journey->setTypeJourney("PIED");
            $journey->setDepartPoint($this->GetPoint($trip["Departure"]["Site"]));
            $journey->setArriveePoint($this->GetPoint($trip["Arrival"]["Site"]));
            $journey->setDistance($trip["Distance"]);
            // Calcul de la durée du trajet
            $interval = new \DateInterval($trip["Duration"]);
            $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
            $journey->setDuree($duration);
            $sections = $trip["sections"]["Section"];
            $journey->setSections($this->getJourneySectionsWalk($sections));
            array_push($allJourney, $journey);
        }

        return $allJourney;
    }

    public function getJourneySectionsWalk($sectionData){
        $tripSections = [];
        foreach ($sectionData as $key => $section) {
            $sectionTrip = null;
            if (isset($section["Leg"])) {
                $sectionTrip = $this->LegSection($section["Leg"]);
            }
            array_push($tripSections, $sectionTrip);
        }

        return $tripSections;
    }

    public function getJourney($journeyData, $infotrafics){
        $infosTrafic = $infotrafics;
        $allInfoTrafic = [];
        foreach ($infosTrafic as $info){
            $infoTrafic = ["externalCode"=>$info->getExternalCode(), "name"=>$info->getName(), "description"=>$info->getDescription(),"debut"=>$info->getDebut(),"fin"=>$info->getFin(), "DisruptedLines"=>$info->getLignes()];
            foreach ($info->getLignes() as $ligne){
                $allInfoTrafic[$ligne->getExternalCode()][] = $infoTrafic;
            }
        }

        $allJourney = [];
        foreach ($journeyData as $trip) {
            $journey = new Journey();
            $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["DepartureTime"]);
            $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $trip["ArrivalTime"]);

            $journey->setDepartDate($startWait->getTimestamp());
            $journey->setArriveeDate($endWait->getTimestamp());

            $journey->setTypeJourney("TC");

            $journey->setDepartPoint($this->GetPoint($trip["Departure"]["Site"]));
            $journey->setArriveePoint($this->GetPoint($trip["Arrival"]["Site"]));

            $journey->setDistance($trip["Distance"]);
            // Calcul de la durée du trajet
            $interval = new \DateInterval($trip["Duration"]);
            $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
            $journey->setDuree($duration);

            $sections = $trip["sections"]["Section"];

            $sections = $this->getJourneySections($sections, $allInfoTrafic);

            $journey->setSections($sections);
            $allInfoPerturbations = [];
            foreach ($sections as $section){
                if($section->getTypeJourney() == "TRANSPORT" && !empty($section->getPerturbations()) ){
                    foreach ($section->getPerturbations() as $perturb){
                        $allInfoPerturbations[] =  $perturb;
                    }
                }
            }

            $journey->setPerturbations($allInfoPerturbations);
            array_push($allJourney, $journey);
        }

        return $allJourney;
    }

    private function getJourneySections($sectionData, $allInfoTrafic){
        $tripSections = [];
        $previousSection = null;
        $nextSection = null;
        foreach ($sectionData as $key => $section) {
            $sectionTrip = null;
            $nextSection = null;
            if(isset($sectionData[$key+1]))
                $nextSection = $sectionData[$key+1];
            if(is_null($previousSection) && !is_null($section["Leg"]) && $section["Leg"]["Departure"]["Site"]["id"] == 0)
                continue;

            if (isset($section["PTRide"])) {
                $sectionTrip = $this->PTRideSection($section["PTRide"], $allInfoTrafic);
            } else if (isset($section["Leg"])) {
                $sectionTrip = $this->LegSection($section["Leg"]);
            }

            array_push($tripSections, $sectionTrip);

            if(!is_null($previousSection) && !is_null($section["Leg"]) && !is_null($nextSection)) {
                $sectionTripAttente = $this->AwaitSection($section, $nextSection);
                array_push($tripSections, $sectionTripAttente);

            }

            $previousSection = $section;
        }

        return $tripSections;
    }

    private function AwaitSection($section, $nextSection){
        $sectionAttente = new JourneyStepAttente();
        $startWait = \DateTime::createFromFormat("d/m/Y H:i:s",$section["Leg"]["Arrival"]["Time"]);
        $endWait = \DateTime::createFromFormat("d/m/Y H:i:s",$nextSection["PTRide"]["Departure"]["Time"]);
        $sectionAttente->setWaitingStartDate($startWait->getTimestamp());
        $sectionAttente->setWaitinEndDate($endWait->getTimestamp());
        $sectionAttente->setDuree($endWait->getTimestamp()-$startWait->getTimestamp());
        $sectionAttente->setWaitingPoint($this->GetPoint($section["Leg"]["Departure"]["Site"]));

        return $sectionAttente;

    }

    private function PTRideSection($ptrideSection, $allInfoTrafic = array()){

        $section = new JourneyStepTransport();
        $perturb = [];
        if(!empty($allInfoTrafic) && isset($allInfoTrafic[$ptrideSection["Line"]["id"]])){
            foreach ($allInfoTrafic[$ptrideSection["Line"]["id"]] as $info){
                $infoTrafic = new JourneyPerturbation();
                $infoTrafic->setExternalCode($info["externalCode"]);
                $infoTrafic->setName($info["name"]);
                if(isset($info["description"])){
                    $infoTrafic->setDescription($info["description"]);
                }
                $infoTrafic->setDebut($info["debut"]);
                $infoTrafic->setFin($info["fin"]);
                $perturbLignes = [];

                if(isset($info["DisruptedLines"]) && is_array($info["DisruptedLines"]) && count($info["DisruptedLines"])>0){
                    foreach ($info["DisruptedLines"] as $ligneRaw){
                        $perturbLignes[] = $ligneRaw;
                    }
                }
                $infoTrafic->setLignes($perturbLignes);
                $perturb[] = $infoTrafic;
            }
        }

        $section->setPerturbations($perturb);

        $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $ptrideSection["Departure"]["Time"]);
        $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $ptrideSection["Arrival"]["Time"]);

        $section->setDepartDate($startWait->getTimestamp());
        $section->setArriveeDate($endWait->getTimestamp());

        $section->setDepartPoint($this->GetPoint($ptrideSection["Departure"]["StopPlace"]));
        $section->setArriveePoint($this->GetPoint($ptrideSection["Arrival"]["StopPlace"]));

        $interval = new \DateInterval($ptrideSection["Duration"]);
        $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
        $section->setDuree($duration);

        $ligne = new RemoteLigne();
        $ligneDbOrigin =  $this->em->getRepository(Ligne::class)->findOneBy(["shortName"=>$ptrideSection["Line"]["Number"]]);

        $ligne->setExternalCode($ligneDbOrigin->getExternalCode());
        $ligne->setDirections([]);
        $section->setDirection($ptrideSection["Direction"]["Id"]);
        $dirObj = new RemoteLigneDirection();
        $dirObj->setExternalCode($ligneDbOrigin->getExternalCode()."_".$ptrideSection["Direction"]["Id"]);
        $dirObj->setName($ptrideSection["Direction"]["Name"]);
        $directions[]=$dirObj;
        $ligne->setDirections($directions);
        $section->setLignes($ligne);
        $section->setStopareas($this->getStopAreaInStep($ptrideSection["steps"]));

        return $section;
    }

    private function LegSection($legSection) {
        $section = new JourneyStepPied();

        $startWait = \DateTime::createFromFormat("d/m/Y H:i:s", $legSection["Departure"]["Time"]);
        $endWait = \DateTime::createFromFormat("d/m/Y H:i:s", $legSection["Arrival"]["Time"]);

        $section->setDepartDate($startWait->getTimestamp());
        $section->setArriveeDate($endWait->getTimestamp());

        $section->setDepartPoint($this->GetPoint($legSection["Departure"]["Site"]));
        $section->setArriveePoint($this->GetPoint($legSection["Arrival"]["Site"]));

        $interval = new \DateInterval($legSection["Duration"]);
        $duration = $interval->days*86400 + $interval->h*3600 + $interval->i*60 + $interval->s;
        $section->setDuree($duration);

        $geoJson = $this->getaditionalGeoJson($legSection);
        $section->setGeojson($geoJson["additionalGeoJson"]);
        $section->setDistance($geoJson["distance"]);

        return $section;

    }

    private function getStopAreaInStep($steps){
        $stopsArea = [];
        $numItems = count($steps["Step"]);
        $i = 0;
        foreach ($steps["Step"] as $key=>$step){
            $currentStop = new RemoteStopArea();
            $currentStop->setCoordLng($step["Departure"]["StopPlace"]["Position"]["Long"]);
            $currentStop->setCoordLat($step["Departure"]["StopPlace"]["Position"]["Lat"]);
            $currentStop->setExternalCode($step["Departure"]["StopPlace"]["LogicalId"]);
            $currentStop->setName($step["Departure"]["StopPlace"]["Name"]);
            $isPmr = false;
            $currentStop->setAccessiblePmr($isPmr);
            $currentStop->setVilleExternalCode($step["Departure"]["StopPlace"]["CityCode"]);
            array_push($stopsArea, $currentStop);
            if(++$i == $numItems) {
                $currentStop = new RemoteStopArea();
                $currentStop->setCoordLng($step["Arrival"]["StopPlace"]["Position"]["Long"]);
                $currentStop->setCoordLat($step["Arrival"]["StopPlace"]["Position"]["Lat"]);
                $currentStop->setExternalCode($step["Arrival"]["StopPlace"]["LogicalId"]);
                $currentStop->setName($step["Arrival"]["StopPlace"]["Name"]);
                $isPmr = false;
                $currentStop->setAccessiblePmr($isPmr);
                $currentStop->setVilleExternalCode($step["Arrival"]["StopPlace"]["CityCode"]);
                array_push($stopsArea, $currentStop);
            }
        }
        return $stopsArea;
    }

    private function getaditionalGeoJson($leg, $mode = ""){
        $links = $leg["pathLinks"]["PathLink"];
        $meters = 0;
        $voieBicycle = 0;
        $voieBicycleDescription = [];
        $allGeometry = array(
            "type"=>"LineString",
            "coordinates"=>array()
        );
        $color = "#646464";
        if($mode == "BIKE")
            $color = "#1f7a1f";
        elseif ($mode == "CAR")
            $color = "#0079bc";
        foreach ($links as $link){

            $meters += $link["Distance"];
            if($mode == "BIKE"){
                if($link["Type"] == "BICYCLE_PATH"){
                    array_push($voieBicycleDescription, ["type"=>"bicycle", "metters"=>$link["Distance"]]);
                    $voieBicycle +=  $link["Distance"];
                } else {
                    array_push($voieBicycleDescription, ["type"=>"nobicycle", "metters"=>$link["Distance"]]);
                }
            }
            if(isset($link["Geometry"])){
                $geometry = $link["Geometry"];
                $tmp = explode("(", $geometry);
                if($tmp[0] == "POINT ")
                    continue; //On prend pas en compte les points unique on veux des lignes
                array_shift($tmp);
                $tmp = explode(")", $tmp[0]);

                $linestring = explode(",",$tmp[0]);

                $firstElement = explode(" ", trim($linestring[0]));
                array_push($allGeometry["coordinates"], $firstElement);
                $secondeElement = explode(" ", trim($linestring[1]));
                array_push($allGeometry["coordinates"], $secondeElement);
            }
        }

        $dataToReturn = [];
        $dataToReturn["additionalGeoJson"] = $allGeometry;
        $dataToReturn["voieBicycle"] = $voieBicycle;
        $dataToReturn["voieBicycleDescription"]=$voieBicycleDescription;
        $dataToReturn["additionalGeoJson"]["properties"]["couleur_ligne"] = $color;
        $dataToReturn["additionalGeoJson"]["properties"]["epaisseur_ligne"] = "bold";
        $dataToReturn["additionalGeoJson"]["properties"]["pointille_ligne"] = null;
        $dataToReturn["additionalGeoJson"]["properties"]["pointille_border"] = true;
        $dataToReturn["additionalGeoJson"]["properties"]["couleur_border"] = $color;
        $dataToReturn["additionalGeoJson"]["properties"]["code_ligne"] = "marche";
        $dataToReturn["additionalGeoJson"]["properties"]["isPopupLigne"] = false;
        $dataToReturn["additionalGeoJson"]["properties"]["isMarche"] = true;
        $dataToReturn["additionalGeoJson"]["properties"]["isVelo"] = false;
        $dataToReturn["distance"] = $meters;


        return $dataToReturn;

    }

    private function GetPoint($section){
        $point = new RemotePointItem();
        $name = $section["Name"];
        if(is_null($section["Name"]))
            $name = "";

        $point->setName($name);
        if(is_null($section["LogicalId"]))
            $point->setExternalCode("null");
        else
            $point->setExternalCode($section["LogicalId"]);
        $point->setType($this->getPointType($section["Type"]));
        $point->setCoordLat(floatval($section["Position"]["Lat"]));
        $point->setCoordLng(floatval($section["Position"]["Long"]));

        return $point;
    }

    private function getPointType($type){
        if($type == "BOARDING_POSITION") {
            return RemotePointItem::TYPE_STOPAREA;
        } else if($type == "ROAD_LINK") {
            return RemotePointItem::TYPE_MANUAL;
        } else if($type == "POI") {
            return RemotePointItem::TYPE_POI;
        } else if($type == "STOP_PLACE") {
            return RemotePointItem::TYPE_STOPAREA;
        }
    }
}
