<?php

namespace Actigraph\CarteBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="Actigraph\CarteBundle\Repository\VilleRepository")
 */
class Ville implements ObjectWithBackObj
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $externalCode;

    /**
     * @ORM\Column(type="string", length=10, nullable=true)
     */
    private $codePostal;

    /**
     * @ORM\Column(type="float")
     */
    private $coordLat;

    /**
     * @ORM\Column(type="float")
     */
    private $coordLng;

    /**
     * @ORM\OneToMany(targetEntity="Actigraph\CarteBundle\Entity\StopArea", mappedBy="ville")
     */
    private $stopAreas;

    /**
     * @ORM\OneToMany(targetEntity="Actigraph\CarteBundle\Entity\Poi", mappedBy="ville")
     */
    private $pois;

    public function __construct()
    {
        $this->stopAreas = new ArrayCollection();
        $this->pois = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getExternalCode(): ?string
    {
        return $this->externalCode;
    }

    public function setExternalCode(?string $externalCode): self
    {
        $this->externalCode = $externalCode;

        return $this;
    }

    public function getCodePostal(): ?string
    {
        return $this->codePostal;
    }

    public function setCodePostal(?string $codePostal): self
    {
        $this->codePostal = $codePostal;

        return $this;
    }

    public function getCoordLat(): ?float
    {
        return $this->coordLat;
    }

    public function setCoordLat(float $coordLat): self
    {
        $this->coordLat = $coordLat;

        return $this;
    }

    public function getCoordLng(): ?float
    {
        return $this->coordLng;
    }

    public function setCoordLng(float $coordLng): self
    {
        $this->coordLng = $coordLng;

        return $this;
    }

    /**
     * @return Collection|StopArea[]
     */
    public function getStopAreas(): Collection
    {
        return $this->stopAreas;
    }

    public function addStopArea(StopArea $stopArea): self
    {
        if (!$this->stopAreas->contains($stopArea)) {
            $this->stopAreas[] = $stopArea;
            $stopArea->setVille($this);
        }

        return $this;
    }

    public function removeStopArea(StopArea $stopArea): self
    {
        if ($this->stopAreas->contains($stopArea)) {
            $this->stopAreas->removeElement($stopArea);
            // set the owning side to null (unless already changed)
            if ($stopArea->getVille() === $this) {
                $stopArea->setVille(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Poi[]
     */
    public function getPois(): Collection
    {
        return $this->pois;
    }

    public function addPois(Poi $pois): self
    {
        if (!$this->pois->contains($pois)) {
            $this->pois[] = $pois;
            $pois->setVille($this);
        }

        return $this;
    }

    public function removePois(Poi $pois): self
    {
        if ($this->pois->contains($pois)) {
            $this->pois->removeElement($pois);
            // set the owning side to null (unless already changed)
            if ($pois->getVille() === $this) {
                $pois->setVille(null);
            }
        }

        return $this;
    }

    public function toArray(){
        return [
            "id"=>$this->getId(),
            "name"=>$this->getName(),
            "externalCode"=>$this->getExternalCode(),
            "coord"=>[
                "lat"=>$this->getCoordLat(),
                "lng"=>$this->getCoordLng()
            ]
        ];
    }
}
