<?php

namespace Actigraph\CarteBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="Actigraph\CarteBundle\Repository\PoiTypeRepository")
 */
class PoiType implements ObjectWithBackObj
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $externalCode;

    /**
     * @ORM\OneToMany(targetEntity="Actigraph\CarteBundle\Entity\Poi", mappedBy="type")
     */
    private $pois;

    public function __construct()
    {
        $this->pois = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getExternalCode(): ?string
    {
        return $this->externalCode;
    }

    public function setExternalCode(?string $externalCode): self
    {
        $this->externalCode = $externalCode;

        return $this;
    }

    /**
     * @return Collection|Poi[]
     */
    public function getPois(): Collection
    {
        return $this->pois;
    }

    public function addPois(Poi $pois): self
    {
        if (!$this->pois->contains($pois)) {
            $this->pois[] = $pois;
            $pois->setType($this);
        }

        return $this;
    }

    public function removePois(Poi $pois): self
    {
        if ($this->pois->contains($pois)) {
            $this->pois->removeElement($pois);
            // set the owning side to null (unless already changed)
            if ($pois->getType() === $this) {
                $pois->setType(null);
            }
        }

        return $this;
    }

    public function toArray()
    {
        return [
            "id"=>$this->getId(),
            "name"=>$this->getName(),
            "externalCode"=>$this->getExternalCode(),
        ];
    }
}
