<?php

namespace Actigraph\CarteBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="Actigraph\CarteBundle\Repository\PoiRepository")
 */
class Poi implements ObjectWithBackObj
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $externalCode;

    /**
     * @ORM\Column(type="array", nullable=true)
     */
    private $extraData = [];

    /**
     * @ORM\Column(type="float")
     */
    private $coordLat;

    /**
     * @ORM\Column(type="float")
     */
    private $coordLng;

    /**
     * @ORM\Column(type="boolean")
     */
    private $coordEdited;

    /**
     * @ORM\Column(type="integer")
     */
    private $coordAngle;

    /**
     * @ORM\Column(type="integer")
     */
    private $coordWidth;

    /**
     * @ORM\Column(type="string", length=255, options={"default" : "default"})
     */
    private $modeAffichage = "default";

    /**
     * @ORM\ManyToOne(targetEntity="Actigraph\CarteBundle\Entity\PoiType", inversedBy="pois")
     * @ORM\JoinColumn(nullable=false)
     */
    private $type;

    /**
     * @ORM\ManyToOne(targetEntity="Actigraph\CarteBundle\Entity\Ville", inversedBy="pois")
     */
    private $ville;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getExternalCode(): ?string
    {
        return $this->externalCode;
    }

    public function setExternalCode(?string $externalCode): self
    {
        $this->externalCode = $externalCode;

        return $this;
    }

    public function getExtraData(): ?array
    {
        return $this->extraData;
    }

    public function setExtraData(?array $extraData): self
    {
        $this->extraData = $extraData;

        return $this;
    }

    public function getCoordLat(): ?float
    {
        return $this->coordLat;
    }

    public function setCoordLat(float $coordLat): self
    {
        $this->coordLat = $coordLat;

        return $this;
    }

    public function getCoordLng(): ?float
    {
        return $this->coordLng;
    }

    public function setCoordLng(float $coordLng): self
    {
        $this->coordLng = $coordLng;

        return $this;
    }

    public function getCoordEdited(): ?bool
    {
        return $this->coordEdited;
    }

    public function setCoordEdited(bool $coordEdited): self
    {
        $this->coordEdited = $coordEdited;

        return $this;
    }

    public function getCoordAngle(): ?int
    {
        return $this->coordAngle;
    }

    public function setCoordAngle(int $coordAngle): self
    {
        $this->coordAngle = $coordAngle;

        return $this;
    }

    public function getCoordWidth(): ?int
    {
        return $this->coordWidth;
    }

    public function setCoordWidth(int $coordWidth): self
    {
        $this->coordWidth = $coordWidth;

        return $this;
    }

    public function getModeAffichage(): ?string
    {
        return $this->modeAffichage;
    }

    public function setModeAffichage(string $modeAffichage): self
    {
        $this->modeAffichage = $modeAffichage;

        return $this;
    }

    public function getType(): ?PoiType
    {
        return $this->type;
    }

    public function setType(?PoiType $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getVille(): ?Ville
    {
        return $this->ville;
    }

    public function setVille(?Ville $ville): self
    {
        $this->ville = $ville;

        return $this;
    }

    public function toArray()
    {
        $villeInfo = [];
        if($this->getVille() != null)
            $villeInfo = $this->getVille()->toArray();
        return [
            "id"=>$this->getId(),
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
            "ville"=>$villeInfo,
            "type"=>[
                "id"=>$this->getType()->getId()
            ],
            "modeAffichage"=>$this->getModeAffichage(),
            "coord"=>[
                "lat"=>$this->getCoordLat(),
                "lng"=>$this->getCoordLng(),
                "width"=>$this->getCoordWidth(),
                "angle"=>$this->getCoordAngle(),
            ],
            "extraData"=>$this->getExtraData(),
        ];
    }
}
