<?php

namespace Actigraph\CarteBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="Actigraph\CarteBundle\Repository\PanneauRepository")
 */
class Panneau
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $fileName;

    /**
     * @ORM\Column(type="string", length=255, options={"default" : "default"})
     */
    private $modeAffichage = "default";

    /**
     * @ORM\Column(type="float")
     */
    private $coordLat;

    /**
     * @ORM\Column(type="float")
     */
    private $coordLng;

    /**
     * @ORM\Column(type="boolean")
     */
    private $coordEdited;

    /**
     * @ORM\Column(type="integer")
     */
    private $coordAngle;

    /**
     * @ORM\Column(type="integer")
     */
    private $coordWidth;

    /**
     * @ORM\Column(type="integer")
     */
    private $fileWidth;

    /**
     * @ORM\Column(type="integer")
     */
    private $fileHeigth;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFileName(): ?string
    {
        return $this->fileName;
    }

    public function setFileName(string $fileName): self
    {
        $this->fileName = $fileName;

        return $this;
    }

    public function getModeAffichage(): ?string
    {
        return $this->modeAffichage;
    }

    public function setModeAffichage(string $modeAffichage): self
    {
        $this->modeAffichage = $modeAffichage;

        return $this;
    }

    public function getCoordLat(): ?float
    {
        return $this->coordLat;
    }

    public function setCoordLat(float $coordLat): self
    {
        $this->coordLat = $coordLat;

        return $this;
    }

    public function getCoordLng(): ?float
    {
        return $this->coordLng;
    }

    public function setCoordLng(float $coordLng): self
    {
        $this->coordLng = $coordLng;

        return $this;
    }

    public function getCoordEdited(): ?bool
    {
        return $this->coordEdited;
    }

    public function setCoordEdited(bool $coordEdited): self
    {
        $this->coordEdited = $coordEdited;

        return $this;
    }

    public function getCoordAngle(): ?int
    {
        return $this->coordAngle;
    }

    public function setCoordAngle(int $coordAngle): self
    {
        $this->coordAngle = $coordAngle;

        return $this;
    }

    public function getCoordWidth(): ?int
    {
        return $this->coordWidth;
    }

    public function setCoordWidth(int $coordWidth): self
    {
        $this->coordWidth = $coordWidth;

        return $this;
    }

    public function getFileWidth(): ?float
    {
        return $this->fileWidth;
    }

    public function setFileWidth(float $fileWidth): self
    {
        $this->fileWidth = $fileWidth;

        return $this;
    }

    public function getFileHeigth(): ?float
    {
        return $this->fileHeigth;
    }

    public function setFileHeigth(float $fileHeigth): self
    {
        $this->fileHeigth = $fileHeigth;

        return $this;

    }

    public function toArray(){
        return [
            "id"=>$this->getId(),
            "filename"=>$this->getFileName(),
            "modeaffichage"=>$this->getModeAffichage(),
            "coord"=>[
                "lat"=>$this->getCoordLat(),
                "lng"=>$this->getCoordLng(),
                "width"=>$this->getCoordWidth(),
                "angle"=>$this->getCoordAngle(),
            ],
            "filewidth"=>$this->getFileWidth(),
            "fileheight"=>$this->getFileHeigth()
        ];
    }
}
