<?php

namespace Actigraph\CarteBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="Actigraph\CarteBundle\Repository\LigneDirectionRepository")
 */
class LigneDirection implements ObjectWithBackObj
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $externalCode;

    /**
     * @ORM\ManyToOne(targetEntity="Actigraph\CarteBundle\Entity\Ligne", inversedBy="ligneDirections")
     */
    private $ligne;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getLigne(): ?Ligne
    {
        return $this->ligne;
    }

    public function setLigne(?Ligne $ligne): self
    {
        $this->ligne = $ligne;

        return $this;
    }

    public function getExternalCode(): ?string
    {
        return $this->externalCode;
    }

    public function setExternalCode(string $externalCode): self
    {
        $this->externalCode = $externalCode;

        return $this;
    }

    public function toArray()
    {
        return [
            "id"=>$this->getId(),
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
        ];
    }
}