<?php

namespace Actigraph\CarteBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="Actigraph\CarteBundle\Repository\LigneRepository")
 */
class Ligne implements ObjectWithBackObj
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=10)
     */
    private $shortName;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $externalCode;

    /**
     * @ORM\Column(type="string", length=255, options={"default" : "default"})
     */
    private $modeAffichage = "default";

    /**
     * @ORM\OneToMany(targetEntity="Actigraph\CarteBundle\Entity\LigneDirection", mappedBy="ligne")
     */
    private $ligneDirections;

    /**
     * @ORM\Column(type="string", length=10)
     */
    private $ligneBackgroundColor;

    /**
     * @ORM\Column(type="string", length=10)
     */
    private $ligneTextColor;

    /**
     * @ORM\Column(type="text")
     */
    private $ligneParams;

    /**
     * @ORM\ManyToOne(targetEntity="Actigraph\CarteBundle\Entity\LigneType", inversedBy="ligne")
     * @ORM\JoinColumn(nullable=false)
     */
    private $type;

    /**
     * @ORM\Column(type="integer")
     */
    private $ordre;

    /**
     * @ORM\Column(type="boolean", name="remote_exist")
     */
    private $remoteExist;

    /**
     * @ORM\Column(type="boolean")
     */
    private $visible;

    public function __construct()
    {
        $this->ligneDirections = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getExternalCode(): ?string
    {
        return $this->externalCode;
    }

    public function setExternalCode(string $externalCode): self
    {
        $this->externalCode = $externalCode;

        return $this;
    }

    public function getModeAffichage(): ?string
    {
        return $this->modeAffichage;
    }

    public function setModeAffichage(string $modeAffichage): self
    {
        $this->modeAffichage = $modeAffichage;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getLigneBackgroundColor()
    {
        return $this->ligneBackgroundColor;
    }

    /**
     * @param mixed $ligneBackgroundColor
     */
    public function setLigneBackgroundColor($ligneBackgroundColor): void
    {
        $this->ligneBackgroundColor = $ligneBackgroundColor;
    }

    /**
     * @return mixed
     */
    public function getLigneTextColor()
    {
        return $this->ligneTextColor;
    }

    /**
     * @param mixed $ligneTextColor
     */
    public function setLigneTextColor($ligneTextColor): void
    {
        $this->ligneTextColor = $ligneTextColor;
    }

    /**
     * @return Collection|LigneDirection[]
     */
    public function getLigneDirections(): Collection
    {
        return $this->ligneDirections;
    }

    public function setLigneDirections(Collection $ligneDirections)
    {
        $this->ligneDirections = $ligneDirections;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getLigneparams()
    {
        return $this->ligneParams;
    }

    /**
     * @param mixed $ligneparams
     */
    public function setLigneparams($ligneParams)
    {
        $this->ligneParams = $ligneParams;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    public function addLigneDirection(LigneDirection $ligneDirection): self
    {
        if (!$this->ligneDirections->contains($ligneDirection)) {
            $this->ligneDirections[] = $ligneDirection;
            $ligneDirection->setLigne($this);
        }

        return $this;
    }

    public function removeLigneDirection(LigneDirection $ligneDirection): self
    {
        if ($this->ligneDirections->contains($ligneDirection)) {
            $this->ligneDirections->removeElement($ligneDirection);
            // set the owning side to null (unless already changed)
            if ($ligneDirection->getLigne() === $this) {
                $ligneDirection->setLigne(null);
            }
        }

        return $this;
    }

    public function toArray(){
        $directions = [];
        if($this->getLigneDirections() != null && count($this->getLigneDirections())>0){
            foreach ($this->getLigneDirections() as $dir){
                $directions[]=$dir->toArray();
            }
        }

        return [
            "id"=>$this->getId(),
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
            "shortName"=>$this->getShortName(),
            "modeAffichage"=>$this->getModeAffichage(),
            "directions"=>$directions,
            "params"=>$this->getLigneparams(),
            "ordre"=>$this->getOrdre(),
            "type"=>[
                "id"=>$this->getType()->getId(),
                "name"=>$this->getType()->getTypeLibelle()
            ],
        ];
    }

    /**
     * @return mixed
     */
    public function getShortName()
    {
        return $this->shortName;
    }

    /**
     * @param mixed $shortName
     */
    public function setShortName($shortName): void
    {
        $this->shortName = $shortName;
    }

    /**
     * @return mixed
     */
    public function getOrdre()
    {
        return $this->ordre;
    }

    /**
     * @param mixed $ordre
     */
    public function setOrdre($ordre): void
    {
        $this->ordre = $ordre;
    }

    /**
     * @return mixed
     */
    public function getRemoteExist()
    {
        return $this->remoteExist;
    }

    /**
     * @param mixed $remoteExist
     */
    public function setRemoteExist($remoteExist): void
    {
        $this->remoteExist = $remoteExist;
    }

    /**
     * @return mixed
     */
    public function getVisible()
    {
        return $this->visible;
    }

    /**
     * @param mixed $visible
     */
    public function setVisible($visible): void
    {
        $this->visible = $visible;
    }

}
