<?php


namespace Actigraph\CarteBundle\Controller;

use Psr\Log\InvalidArgumentException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Actigraph\CarteBundle\Service\BackService;
use Actigraph\CarteBundle\Service\ReferentielService;
use Actigraph\CarteBundle\Entity\StopArea;
use Actigraph\CarteBundle\Entity\Panneau;
use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Entity\PoiType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;


/**
 * @Route("/admin")
 */
class AdminController extends AbstractController
{
    /**
     * @Route("/savemarkeramodif", name="admin_savemarkermodif", options={"expose"=true})
     */
    public function saveStopAreaModif(Request $request,BackService $backService,ReferentielService $referentielService, EntityManagerInterface $entityManager){
        $response = new JsonResponse();
        if ($request->getMethod() == 'POST') {
            $data = $request->request->all();

            if(!empty($data["modificationsSTOP"])){
                foreach ($data["modificationsSTOP"] as $modif){
                    if($modif["save"] != "true")
                        continue;

                    /** @var StopArea $stopArea */
                    $stopArea = $entityManager->getRepository(StopArea::class)->findOneBy(array("id"=>$modif["id"]));
                    $stopArea->setCoordLng($modif["coord"]["lng"]);
                    $stopArea->setCoordLat($modif["coord"]["lat"]);
                    $stopArea->setCoordAngle(intval($modif["coord"]["angle"]));
                    $stopArea->setCoordWidth(intval($modif["coord"]["width"]));
                    $stopArea->setCoordEdited(true);

                    $entityManager->persist($stopArea);

                    try {
                        $referentielService->cache->deleteItem("back.listStopArea");
                    } catch (InvalidArgumentException $e){

                    }
                }

                $entityManager->flush();
            }
            if(!empty($data["modificationsPOI"])){
                foreach ($data["modificationsPOI"] as $modif){
                    if($modif["save"] != "true")
                        continue;

                    /** @var Poi $poi */
                    $poi = $entityManager->getRepository(Poi::class)->findOneBy(array("id"=>$modif["id"]));
                    $poi->setCoordLng($modif["coord"]["lng"]);
                    $poi->setCoordLat($modif["coord"]["lat"]);
                    $poi->setCoordEdited(true);
                    $entityManager->persist($poi);

                    try {
                        $referentielService->cache->delete("back.listPoiByTypeId".$poi->getType()->getId());
                    } catch (InvalidArgumentException $e){

                    }
                }

                $entityManager->flush();
            }
            if(!empty($data["modificationsPANNEAU"])){
                foreach ($data["modificationsPANNEAU"] as $modif){
                    if($modif["save"] != "true")
                        continue;
                    /** @var Panneau $panneau */
                    $panneau = $entityManager->getRepository(Panneau::class)->findOneBy(array("id"=>$modif["id"]));
                    $panneau->setCoordLng($modif["coord"]["lng"]);
                    $panneau->setCoordLat($modif["coord"]["lat"]);
                    $panneau->setCoordEdited(true);
                    $entityManager->persist($panneau);

                    try {
                        $referentielService->cache->deleteItem("back.listPanneaux");
                    } catch (InvalidArgumentException $e){

                    }
                }

                $entityManager->flush();
            }

        }

        $response->setData(
            array(
                "success"=>true
            )
        );

        return $response;
    }


    /**
     * @Route("/savenewpoi", name="admin_savenewpoi", options={"expose"=true})
     */
    public function saveNewPoi(Request $request,BackService $backService,ReferentielService $referentielService, EntityManagerInterface $entityManager){
        $response = new JsonResponse();

        if ($request->getMethod() == 'POST') {
            $form = $request->request->all();
            if(!empty($form)){
                $data = $form["added"];
                $poi = new Poi();
                $allWithType = $entityManager->getRepository(Poi::class)->findBy(array("type"=>$data["type"]));
                $poi->setType($entityManager->getReference(PoiType::class,$data["type"]));
                $poi->setName($data["nom"]);
                $poi->setCoordLng($data["lng"]);
                $poi->setCoordLat($data["lat"]);
                $poi->setCoordEdited(false);
                $poi->setCoordAngle(0);
                $poi->setCoordWidth(0);
                $extraParams = [];

                $extraParams["adresse"] = $data["adresse"];
                if(isset($data["extraData"])) {
                    foreach ($data["extraData"] as $extra){
                        if($extra["type"] == "code"){
                            if($extra["val"] === ""){
                                $poi->setExternalCode(strval(count($allWithType)+1));
                            } else {
                                $poi->setExternalCode($extra["val"]);
                            }
                        }
                        $extraParams[$extra["type"]] = $extra["val"];
                    }
                }


                $extraParams["ville"] = array(
                    "name"=>$data["ville"],
                    "cp"=>$data["cp"]
                );

                $poi->setExtraData($extraParams);

                $entityManager->persist($poi);
                $entityManager->flush();


                try {
                    $referentielService->cache->deleteItem("back.listPoiByTypeId".$poi->getType()->getId());
                } catch (InvalidArgumentException $e){

                }

            }

        }

        $response->setData(
            array(
                "success"=>true
            )
        );

        return $response;

    }


    /**
     * @Route("/deletepoi", name="admin_deletepoi", options={"expose"=true})
     */
    public function deletePoi(Request $request,BackService $backService,ReferentielService $referentielService, EntityManagerInterface $entityManager){
        $response = new JsonResponse();

        $id = $request->query->get("id","");

        $poi = $entityManager->getRepository(Poi::class)->findOneBy(array("id"=>$id));

        try {
            $referentielService->cache->deleteItem("back.listPoiByTypeId".$poi->getType()->getId());
        } catch (InvalidArgumentException $e){

        }
        $entityManager->remove($poi);
        $entityManager->flush();

        $response->setData(
            array(
                "success"=>true
            )
        );

        return $response;

    }

    /**
     * @Route("/editpoi", name="admin_editpoi", options={"expose"=true})
     */
    public function editPoi(Request $request,BackService $backService,ReferentielService $referentielService, EntityManagerInterface $entityManager){
        $response = new JsonResponse();
        $id = $request->query->get("id","");
        $poi = $entityManager->getRepository(Poi::class)->findOneBy(array("id"=>$id));
        $data = $poi->toArray();

        if ($request->getMethod() == 'POST') {
            $form = $request->request->all();
            if(!empty($form)){
                $data = $form["edit"];
                $allWithType = $entityManager->getRepository(Poi::class)->findBy(array("type"=>$data["type"]));
                $poi->setType($entityManager->getReference(PoiType::class,$data["type"]));
                $poi->setName($data["nom"]);
                $extraParams = [];

                foreach ($data["extraData"] as $extra){
                    if($extra["type"] == "code"){
                        if($extra["val"] === ""){
                            $poi->setExternalCode(strval(count($allWithType)+1));
                        } else {
                            $poi->setExternalCode($extra["val"]);
                        }
                    }
                    $extraParams[$extra["type"]] = $extra["val"];
                }

                $extraParams["adresse"] = $data["adresse"];

                $extraParams["ville"] = array(
                    "name"=>$data["ville"],
                    "cp"=>$data["cp"]
                );

                $poi->setExtraData($extraParams);
                try {
                    $referentielService->cache->deleteItem("back.listPoiByTypeId".$poi->getType()->getId());
                } catch (InvalidArgumentException $e){

                }
                $entityManager->persist($poi);
                $entityManager->flush();
            }
        }

        $response->setData(
            array(
                "success"=>true,
                "data"=>$data
            )
        );

        return $response;

    }

}