<?php

namespace Actigraph\CarteBundle\Service;

use App\Entity\Gtfs\Ligne;
use App\Entity\Gtfs\LigneSequence;
use Doctrine\ORM\EntityManagerInterface;
use Psr\Cache\InvalidArgumentException;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Cache\Adapter\TagAwareAdapter;
use Symfony\Contracts\Cache\CacheInterface;

class GtfsService
{
    private $entityManager;
    private $config;
    private $cache;

    public function __construct(EntityManagerInterface $entityManager, $config)
    {
        $this->entityManager = $entityManager;
        $this->config = $config;
        $this->cache = new FilesystemAdapter();
    }

    public function getLignes()
    {
        $cacheKey = "back.gtfs.get-lignes";
        $lignes = [];
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $lignes;
        }

        if(!$cacheItem->isHit()){
            $lignes = $this->entityManager->getRepository(Ligne::class)->findAll();
            $cacheItem->set($lignes);
            $cacheItem->expiresAfter(10);
            $this->cache->save($cacheItem);
        } else {
            $lignes = $cacheItem->get();
        }

        return $lignes;
    }

    public function getLignesWithArrets()
    {
        $cacheKey = "back.gtfs.get-lignes-with-arrets";
        $lignes = [];
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $lignes;
        }

        if(!$cacheItem->isHit()){
            $lignes = $this->entityManager->getRepository(Ligne::class)->getLignesWithArrets();
            $cacheItem->set($lignes);
            $cacheItem->expiresAfter(10);
            $this->cache->save($cacheItem);
        } else {
            $lignes = $cacheItem->get();
        }

        return $lignes;
    }

    public function getLigneWithOrderedArrets($id, $direction)
    {
        $cacheKey = "back.gtfs.get-ligne-".$id."-with-ordered-arrets-".$direction;
        $ligne = '';
        try {
            $cacheItem = $this->cache->getItem($cacheKey);
        } catch (InvalidArgumentException $e){
            return $ligne;
        }

        if(!$cacheItem->isHit()){
            $result = $this->entityManager->getRepository(Ligne::class)->getLigneWithOrderedArrets($id, $direction);
            dump($result);
            $ligne = $result[0];
            $cacheItem->set($ligne);
            $cacheItem->expiresAfter(1);
            $this->cache->save($cacheItem);
        } else {
            $ligne = $cacheItem->get();
        }

        return $ligne;
    }
}