<?php


namespace Actigraph\CarteBundle\Service\BackObj;


use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemoteInfoTrafic implements ObjectWithBackObj
{
    /** @var string $externalCode */
    private $externalCode="";

    /** @var string $name */
    private $name="";

    /** @var string $description */
    private $description="";

    /** @var \DateTime $debut */
    private $debut;

    /** @var \DateTime $fin */
    private $fin;

    /** @var []ObjectWithBackObj $stopareas */
    private $stopareas;

    /** @var []ObjectWithBackObj $lignes */
    private $lignes;

    /**
     * @return string
     */
    public function getExternalCode(): string
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode(string $externalCode): void
    {
        $this->externalCode = $externalCode;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description): void
    {
        $this->description = $description;
    }

    /**
     * @return \DateTime
     */
    public function getDebut(): \DateTime
    {
        return $this->debut;
    }

    /**
     * @param \DateTime $debut
     */
    public function setDebut(\DateTime $debut): void
    {
        $this->debut = $debut;
    }

    /**
     * @return \DateTime
     */
    public function getFin(): \DateTime
    {
        return $this->fin;
    }

    /**
     * @param \DateTime $fin
     */
    public function setFin(\DateTime $fin): void
    {
        $this->fin = $fin;
    }

    /**
     * @return mixed
     */
    public function getStopareas()
    {
        return $this->stopareas;
    }

    /**
     * @param mixed $stopareas
     */
    public function setStopareas($stopareas): void
    {
        $this->stopareas = $stopareas;
    }

    /**
     * @return mixed
     */
    public function getLignes()
    {
        return $this->lignes;
    }

    /**
     * @param mixed $lignes
     */
    public function setLignes($lignes): void
    {
        $this->lignes = $lignes;
    }

    public function toArray(){
        $lignesData = [];
        if($this->getLignes() != null && count($this->getLignes())>0){
            foreach ($this->getLignes() as $ligne){
                $lignesData[]=$ligne->toArray();
            }
        }

        return [
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
            "description"=>$this->getDescription(),
            "debut"=>$this->getDebut(),
            "debutTS"=>$this->getDebut()->getTimestamp(),
            "fin"=>$this->getFin(),
            "finTS"=>$this->getFin()->getTimestamp(),
            "lignes"=>$lignesData
        ];
    }
}