<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 11/06/2019
 * Time: 14:15
 */

namespace Actigraph\CarteBundle\Service\Back;
use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Entity\Ligne;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigne;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigneDirection;
use Actigraph\CarteBundle\Service\BackObj\RemotePoi;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Actigraph\CarteBundle\Service\BackObj\Journey;
use Actigraph\CarteBundle\Service\BackObj\JourneyCarPooling;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepTransport;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepAttente;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepPied;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepBike;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepCar;
use Actigraph\CarteBundle\Service\BackObj\JourneyPerturbation;
use Actigraph\CarteBundle\Service\BackObj\RemotePointItem;



class TanBack implements BackInterface {


    private $config;
    private $em;
    public function __construct(EntityManagerInterface $em, $backConfig)
    {
        $this->em = $em;
        $this->config = $backConfig;
    }

    public function listVilles(): array
    {
        return [];
    }

    public function listStoparea(): array
    {
        return [];
    }

    public function listLignes(): array
    {
        return [];
    }

    public function listCurrentInfosTrafics(): array
    {
        return [];
    }

    public function listPoiByTypeExternalCode(string $typeExternalCode, array $extraParams): array
    {
        return [];
    }

    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi
    {
        return $poi;
    }

    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array
    {

        return [];
    }

    public function getJourneyCovoiturage($from,$to,$dateTime,$dateTimeRepresent, $extra){
        $dateTmp = new \DateTime();
        $date = $dateTmp->format("Y-m-d_H-i");
        $departureString = "DepartureType=COORDINATES&DepartureLatitude=".$from["coord"]["lat"]."&DepartureLongitude=".$from["coord"]["lng"]."";
        $arriveeString = "ArrivalType=COORDINATES&ArrivalLatitude=".$to["coord"]["lat"]."&ArrivalLongitude=".$to["coord"]["lng"]."";

        if($dateTimeRepresent != "now")
            $date = $dateTime;

        $date = "Date=".$date;

        $dateType = "DateType=DEPARTURE";
        if($dateTimeRepresent == "after"){
            $dateType = "DateType=ARRIVAL";
        }
        $curl = curl_init();
        curl_reset($curl);
        curl_setopt($curl, CURLOPT_URL, $this->config["url"]."/getItineraire?".$departureString."&".$arriveeString."&".$date."&".$dateType);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 10);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        if(!$result){throw new \Exception('connection failure');}
        curl_close($curl);
        $results =  json_decode($result, true);
        $allTrips = [];

        if(isset($results["Operateurs"])){
            $tripsArray = [];
            if (!empty($results["Operateurs"]["Klaxit"])) {
                foreach ($results["Operateurs"]["Klaxit"] as $trip) {
                    array_push($tripsArray, $trip);
                }
            }
            if(!empty($tripsArray)){
                $allTrips = $this->getTripCovoiturage($tripsArray);
            }
        }

        return $allTrips;
    }


    public function getTripCovoiturage($journeyData){
        $allJourney = [];
        foreach ($journeyData as $trip) {
            $journey = new Journey();
            $journey->setDepartDate($trip["departure_time"]);
            $journey->setArriveeDate($trip["arrival_time"]);

            $journey->setTypeJourney("CARPOOLING");

            if(isset($trip["legs"]) && isset($trip["legs"][0]["steps"])){
                $journey->setDepartPoint($this->GetPoint($trip["legs"][0]["steps"][0]));
                $journey->setArriveePoint($this->GetPoint(end($trip["legs"])["from"]));
            }

            $journey->setDistance(0);
            $journey->setDuree($trip["duration"]);

            $sections = $trip["legs"];
            $sections = $this->getJourneySectionCovoiturage($sections);
            $journey->setSections($sections);

            array_push($allJourney, $journey);
        }


        return $allJourney;
    }

    public function getJourneySectionCovoiturage($sectionData){
        $tripSections = [];

        foreach ($sectionData as $key => $section) {
            $sectionTrip = null;
            if($section["mode"] === "WALK"){
                $sectionTrip = $this->LegSection($section);
            } elseif($section["mode"] === "TRAM"){
                $sectionTrip = $this->PTRideSection($section);
            } elseif($section["mode"] === "BUS"){
                $sectionTrip = $this->PTRideSection($section);
            } elseif($section["mode"] === "CARPOOLING"){
                $sectionTrip = $this->CarPoolingSection($section);
            } else {
                $tripSections = null;
            }

            array_push($tripSections, $sectionTrip);
        }

        return $tripSections;
    }
    public function GetPoint($section){
        $point = new RemotePointItem();
        $name = "";
        if(isset($section["name"]))
            $name = $section["name"];
        elseif (isset($section["street_name"]))
            $name = $section["street_name"];

        $point->setName($name);
        $point->setExternalCode("null");
        $point->setType(RemotePointItem::TYPE_MANUAL);
        $point->setCoordLat(floatval($section["lat"]));
        $point->setCoordLng(floatval($section["lng"]));

        return $point;
    }

    public function LegSection($legSection){
        $section = new JourneyStepPied();

        $section->setDepartDate($legSection["departure_time"]);
        $section->setArriveeDate($legSection["arrival_time"]);

        if($legSection["from"] == "Origin"){
            $section->setDepartPoint($this->GetPoint($legSection["steps"][0]));
        } else {
            $section->setDepartPoint($this->GetPoint($legSection["from"]));
        }

        if($legSection["to"] == "Destination"){
            $section->setArriveePoint($this->GetPoint(end($legSection["steps"])["from"]));
        } else {
            $section->setArriveePoint($this->GetPoint($legSection["steps"][0]));
        }

        $points = \Polyline::decode($legSection["polyline"]);
        $geojsontmp = \Polyline::pair($points);
        $additionalGeoJson = $this->getaditionalGeoJson($geojsontmp, "leg");
        $section->setGeojson($additionalGeoJson["additionalGeoJson"]);
        $section->setDuree($legSection["duration"]);
        $section->setDistance($legSection["distance"]);

        return $section;

    }

    public function CarPoolingSection($carPoolingSection){
        $section = new JourneyCarPooling();
        $section->setDepartDate($carPoolingSection["departure_time"]);
        $section->setArriveeDate($carPoolingSection["arrival_time"]);

        $section->setDepartPoint($this->GetPoint($carPoolingSection["from"]));
        $section->setArriveePoint($this->GetPoint($carPoolingSection["to"]));
        $points = \Polyline::decode($carPoolingSection["polyline"]);
        $geojsontmp = \Polyline::pair($points);
        $additonalGeojson = $this->getaditionalGeoJson($geojsontmp, "carpooling");
        $section->setRoad($additonalGeojson["additionalGeoJson"]);
        $section->setDuree($carPoolingSection["duration"]);
        //$section->setRoad($carPoolingSection["polyline"]);
        $section->setDistance($carPoolingSection["distance"]);
        $section->setDistance($carPoolingSection["distance"]);
        $section->setDistance($carPoolingSection["distance"]);
        $driver = array(
            "name"=>$carPoolingSection["driver"]["name"],
            "picture"=>$carPoolingSection["driver"]["picture"]
        );

        $section->setDriver($driver);
        $section->setExtraData(array());

        return $section;
    }

    public function PTRideSection($ptrideSection){
        $section = new JourneyStepTransport();
        $section->setDepartDate($ptrideSection["departure_time"]);
        $section->setArriveeDate($ptrideSection["arrival_time"]);

        $section->setDepartPoint($this->GetPoint($ptrideSection["from"]));
        $section->setArriveePoint($this->GetPoint($ptrideSection["to"]));

        $section->setDuree($ptrideSection["duration"]);
        $ligne = new RemoteLigne();
        $ligneDbOrigin =  $this->em->getRepository(Ligne::class)->findOneBy(["shortName"=>$ptrideSection["route"]]);
        $ligne->setExternalCode($ligneDbOrigin->getExternalCode());

        $section->setDirection($ptrideSection["headsign"]);

        $section->setLignes($ligne);
        return $section;
    }

    private function getaditionalGeoJson($polyline, $mode){
        $color = "#646464";
        for($i = 0; $i<count($polyline); $i++){
            $polyline[$i] = array_map('strval', $polyline[$i]);
            $polyline[$i]  = array_reverse($polyline[$i]);
        }
        if($mode == "carpooling"){
            $color = "#0079bc";
        }

        $allGeometry = array(
            "type"=>"LineString",
            "coordinates"=>array()
        );
        $meters = "";
        $allGeometry["coordinates"] = $polyline;

        $dataToReturn = [];
        $dataToReturn["additionalGeoJson"] = $allGeometry;
        $dataToReturn["voieBicycle"] = 0;
        $dataToReturn["voieBicycleDescription"]=[];
        $dataToReturn["additionalGeoJson"]["properties"]["couleur_ligne"] = $color;
        $dataToReturn["additionalGeoJson"]["properties"]["epaisseur_ligne"] = "bold";
        $dataToReturn["additionalGeoJson"]["properties"]["pointille_ligne"] = null;
        $dataToReturn["additionalGeoJson"]["properties"]["pointille_border"] = true;
        $dataToReturn["additionalGeoJson"]["properties"]["couleur_border"] = $color;
        $dataToReturn["additionalGeoJson"]["properties"]["code_ligne"] = "marche";
        $dataToReturn["additionalGeoJson"]["properties"]["isPopupLigne"] = false;
        $dataToReturn["additionalGeoJson"]["properties"]["isMarche"] = true;
        $dataToReturn["additionalGeoJson"]["properties"]["isVelo"] = false;
        $dataToReturn["distance"] = $meters;
        return $dataToReturn;

    }
}
