<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 11/06/2019
 * Time: 14:15
 */

namespace Actigraph\CarteBundle\Service\Back;
use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Service\BackObj\RemotePoi;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;


class JCDecaux implements BackInterface {


    private $config;
    private $em;
    public function __construct(EntityManagerInterface $em, $backConfig)
    {
        $this->em = $em;
        $this->config = $backConfig;
    }

    public function listVilles(): array
    {
        return [];
    }

    public function listStoparea(): array
    {
        return [];
    }

    public function listLignes(): array
    {
        return [];
    }

    public function listCurrentInfosTrafics(): array
    {
        return [];
    }

    public function listPoiByTypeExternalCode(string $typeExternalCode, array $extraParams): array
    {
        $listeStations = [];
        $url =  $this->config["url"];
        if($typeExternalCode == 2)
            $url .= "/vls/v3/stations?apiKey=".$this->config["apiKey"]."&contract=".$this->config["contractName"];
        else
            return $listeStations;

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);

        $response = curl_exec($curl);
        curl_close($curl);

        if ($response == "") {
            return $listeStations;
        } else {
            $poiListe = json_decode($response);

            foreach ($poiListe as $poi) {
                $remotePoi = new RemotePoi();
                $nomTmp = explode("-", $poi->name, 2);
                if(count($nomTmp)==2)
                    $nom = mb_strtolower(trim($nomTmp[1]), "UTF-8");
                else
                    $nom = mb_strtolower(trim($poi->name), "UTF-8");
                $remotePoi->setLng($poi->position->longitude);
                $remotePoi->setLat($poi->position->latitude);
                $remotePoi->setName("Station Bicloo ".ucfirst($nom)." (".ucfirst($poi->contractName).")");
                $remotePoi->setExternalCode($poi->number);

                $extraParams["adresse"] = $poi->address;
                $extraParams["ville"] = array(
                    "name" => (string)$poi->contractName
                );

                if($typeExternalCode == 2)
                    $extraParams["capacite"]= $poi->totalStands->capacity;


                $remotePoi->setExtraData($extraParams);
                $listeStations[]=$remotePoi;

            }
        }


        return $listeStations;
    }

    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi
    {
        return $poi;
    }

    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array
    {
        $url =  $this->config["url"];
        if($typeExternalCode == 2){
            $availablePlace = [];
            $url .= "/vls/v3/stations?apiKey=".$this->config["apiKey"]."&contract=".$this->config["contractName"];

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_TIMEOUT, 5);

            $response = curl_exec($curl);
            curl_close($curl);

            if ($response == "") {
                return $pois;
            } else {
                $poiListe = json_decode($response);
                foreach ($poiListe as $poi){
                    $availablePlace[$poi->number] = sprintf("%02d", $poi->totalStands->availabilities->bikes);
                }

                foreach ($pois as $poi){
                   $extraParams = $poi->getExtraData();
                   if(isset($availablePlace[$poi->getExternalCode()]))
                       $extraParams["dispo"] = $availablePlace[$poi->getExternalCode()];
                   else
                       $extraParams["dispo"] = 00;

                    $poi->setExtraData($extraParams);
                }
            }
        }
        return $pois;
    }
}
