<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 19/09/2019
 * Time: 16:34
 */

namespace Actigraph\CarteBundle\Service\Back;
use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Entity\Ligne;
use Actigraph\CarteBundle\Service\BackObj\RemoteInfoTrafic;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigne;
use Actigraph\CarteBundle\Service\BackObj\RemotePointItem;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopArea;
use Actigraph\CarteBundle\Service\BackObj\RemoteVille;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopLines;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopTimeTable;
use Actigraph\CarteBundle\Service\BackObj\RemoteLineTimeTable;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Validator\Constraints\Date;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigneDirection;
use Actigraph\CarteBundle\Service\BackObj\Journey;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepTransport;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepAttente;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepPied;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepBike;
use Actigraph\CarteBundle\Service\BackObj\JourneyPerturbation;

class ActipageBack implements BackInterface {


    private $config;
    private $em;
    public function __construct(EntityManagerInterface $em, $backConfig)
    {
        $this->em = $em;
        $this->config = $backConfig;
    }

    public function listVilles(): array{

        return [];
    }
    public function listStoparea(): array{

        return [];
    }
    public function listLignes(): array{

        return [];
    }
    public function listCurrentInfosTrafics(): array
    {
        $listPerturbations = [];

        $now = time();
        $curl = curl_init();
        $urlApi =$this->config["url"]."/infotrafics.php?startdate=". $now;
        if($this->config["isNewFront"])
            $urlApi = $this->config["url"]."/api/perturbations?startdate=". $now;

        curl_setopt($curl, CURLOPT_URL, $urlApi);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 3);
        curl_setopt($curl, CURLOPT_TIMEOUT, 3);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $result = curl_exec($curl);
        if (!$result) {
            return $listPerturbations;
        }
        curl_close($curl);
        $results = json_decode($result, true);
        if (is_array($results)) {
            foreach ($results as $dataPerturb) {
                $perturb = new RemoteInfoTrafic();
                $perturb->setExternalCode($dataPerturb["info"]["id"]);
                $name = "";
                if (!is_null($dataPerturb["info"]["titre"]))
                    $name = $dataPerturb["info"]["titre"];
                $perturb->setName($name);

                $description = "";
                if (!is_null($dataPerturb["info"]["accroche"]))
                    $description = $dataPerturb["info"]["accroche"];
                $perturb->setDescription($description);
                $perturb->setDebut(\DateTime::createFromFormat('Y-m-d H:i:s', $dataPerturb["info"]["date_debut"]));
                $perturb->setFin(\DateTime::createFromFormat('Y-m-d H:i:s', $dataPerturb["info"]["date_fin"]));
                $perturbLignes = [];
                if (isset($dataPerturb["lines"]) && is_array($dataPerturb["lines"]) && count($dataPerturb["lines"]) > 0) {
                    foreach ($dataPerturb["lines"] as $ligneRaw) {
                        $ligneDbOrigin = $this->em->getRepository(Ligne::class)->findOneBy(["name" => strtoupper($ligneRaw["line_name"])]);
                        if (!is_null($ligneDbOrigin)) {
                            if (!isset($perturbLignes[$ligneRaw["id"]])) {
                                $ligne = new RemoteLigne();
                                $ligne->setExternalCode($ligneDbOrigin->getExternalCode());
                                $ligne->setDirections([]);
                                $perturbLignes[$ligneDbOrigin->getExternalCode()] = $ligne;
                            }
                            $dir = new RemoteLigneDirection();

                            $perturbLignes[$ligneDbOrigin->getExternalCode()]->addDirection($dir);
                        }
                    }
                }
                $perturb->setLignes($perturbLignes);
                $listPerturbations[] = $perturb;
            }
        }

        return $listPerturbations;
    }
    public function listPoiByTypeExternalCode(string $typeExternalCode,array $extraParams): array{

        return [];
    }
    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi
    {
        return $poi;
    }
    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array
    {

        return [];
    }
}
