<?php

namespace Actigraph\CarteBundle\Controller;

use Actigraph\CarteBundle\Entity\Ligne;
use Actigraph\CarteBundle\Service\GtfsService;
use Actigraph\CarteBundle\Service\ReferentielService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * @Route("/gtfs")
 */
class GtfsController extends AbstractController
{
    /**
     * @Route("/lignes", name="gtfs_lignes", options={"expose"=true})
     */
    public function getLignes(Request $request, GtfsService $gtfsService)
    {
        $lignes = $gtfsService->getLignes();

        return new JsonResponse($lignes);
    }

    /**
     * @Route("/lignes-arrets", name="gtfs_lignes_arrets", options={"expose"=true})
     */
    public function getLignesWithArrets(Request $request, GtfsService $gtfsService)
    {
        $lignes = $gtfsService->getLignesWithArrets();

        return new JsonResponse($lignes);
    }

    /**
     * @Route("/ligne/{id}/ordered-arrets/{direction}", name="gtfs_ligne", options={"expose"=true})
     */
    public function getLigneWithOrderedArrets($id, $direction, GtfsService $gtfsService)
    {
        $ligne = $gtfsService->getLigneWithOrderedArrets($id, $direction);

        return new JsonResponse($ligne);
    }
}