<?php

namespace Actigraph\CarteBundle\Service\BackObj;
use Actigraph\CarteBundle\Entity\ObjectWithBackObj;


class RemoteLineTimeTable implements ObjectWithBackObj
{

    /** @var ObjectWithBackObj $lignes */
    private $ligne;

    /** @var $stopareas */
    private $stopareas;

    /** @var []$nextDeparture */
    private $nextDepartures;

    /**
     * @return mixed
     */
    public function getLigne()
    {
        return $this->ligne;
    }

    /**
     * @param mixed $ligne
     */
    public function setLigne($ligne): void
    {
        $this->ligne = $ligne;
    }

    /**
     * @return mixed
     */
    public function getStopareas()
    {
        return $this->stopareas;
    }

    /**
     * @param mixed $stopareas
     */
    public function setStopareas($stopareas): void
    {
        $this->stopareas = $stopareas;
    }

     /**
     * @return mixed
     */
    public function getnextDepartures()
    {
        return $this->nextDepartures;
    }

    /**
     * @param mixed $nextDeparture
     */
    public function setnextDepartures($nextDepartures): void
    {
        $this->nextDepartures = $nextDepartures;
    }

    public function toArray(){
        $stopAreasData = [];

        foreach ($this->getStopareas() as $stoparea){
            if($stoparea != "")
                $stopAreasData[]=$stoparea->toArray();
        }

        return [
            "lignes"=>$this->getLigne()->toArray(),
            "stopareas"=>$stopAreasData,
            "nextDepartures"=>$this->getnextDepartures()
        ];
    }
}

?>