<?php


namespace Actigraph\CarteBundle\Service\BackObj;


use Actigraph\CarteBundle\Entity\ObjectWithBackObj;

class RemoteLigne implements ObjectWithBackObj
{
    /** @var string $externalCode */
    private $externalCode="";

    /** @var string $name */
    private $name="";

    /** @var string $shortName */
    private $shortName="";

    /** @var string $textColor */
    private $textColor="";

    /** @var string $backgroundColor */
    private $backgroundColor="";

    /** @var RemoteLigneDirection[] $directions */
    private $directions=[];

    /**
     * @return string
     */
    public function getExternalCode(): string
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode(string $externalCode): void
    {
        $this->externalCode = $externalCode;
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getLigneTextColor(): string
    {
        return $this->textColor;
    }

    /**
     * @param string $textColor
     */
    public function setLigneTextColor(string $textColor): void
    {
        $this->textColor = $textColor;
    }

    /**
     * @return string
     */
    public function getLigneBackgroundColor(): string
    {
        return $this->backgroundColor;
    }

    /**
     * @param string $backgroundColor
     */
    public function setLigneBackgroundColor(string $backgroundColor): void
    {
        $this->backgroundColor = $backgroundColor;
    }

    /**
     * @return RemoteLigneDirection[]
     */
    public function getDirections(): array
    {
        return $this->directions;
    }

    /**
     * @param RemoteLigneDirection[] $directions
     */
    public function setDirections(array $directions): void
    {
        $this->directions = $directions;
    }

    public function addDirection(RemoteLigneDirection $direction){
        $this->directions[]=$direction;
    }
    /**
     * @return string
     */
    public function getShortName(): string
    {
        return $this->shortName;
    }

    /**
     * @param string $shortName
     */
    public function setShortName(string $shortName): void
    {
        $this->shortName = $shortName;
    }

    public function toArray(){
        $directions = [];
        if($this->getDirections() != null && count($this->getDirections())>0){
            foreach ($this->getDirections() as $dir){
                $directions[]=$dir->toArray();
            }
        }

        return [
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
            "shortName"=>$this->getShortName(),
            "directions"=>$directions
        ];
    }
}