<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 14/06/2019
 * Time: 11:02
 */

namespace Actigraph\CarteBundle\Service\BackObj;


class JourneyStepBike implements JourneyStep
{

    /** @var string $typeJourney */
    private $typeJourney ="BIKE";

    /** @var string $typePoints */
    private $typePoints ="";

    /** @var RemotePointItem $departPoint */
    private $departPoint ="";

    /** @var RemotePointItem $arriveePoint */
    private $arriveePoint ="";

    /** @var string $departDate */
    private $departDate ="";

    /** @var string $arriveeDate */
    private $arriveeDate ="";

    /** @var string $duree */
    private $duree ="";

    /** @var string $distance */
    private $distance ="";

    /** @var $road */
    private $road;

    /** @var [] $extraData */
    private $extraData;


    /**
     * @return string
     */
    public function getTypeJourney()
    {
        return $this->typeJourney;
    }

    /**
     * @param string $typeJourney
     */
    public function setTypeJourney($typeJourney)
    {
        $this->typeJourney = $typeJourney;
    }

    /**
     * @return string
     */
    public function getTypePoints()
    {
        return $this->typePoints;
    }

    /**
     * @param string $typePoints
     */
    public function setTypePoints($typePoints)
    {
        $this->typePoints = $typePoints;
    }

    /**
     * @return RemotePointItem
     */
    public function getDepartPoint()
    {
        return $this->departPoint;
    }

    /**
     * @param RemotePointItem $departPoint
     */
    public function setDepartPoint($departPoint)
    {
        $this->departPoint = $departPoint;
    }

    /**
     * @return RemotePointItem
     */
    public function getArriveePoint()
    {
        return $this->arriveePoint;
    }

    /**
     * @param RemotePointItem $arriveePoint
     */
    public function setArriveePoint($arriveePoint)
    {
        $this->arriveePoint = $arriveePoint;
    }

    /**
     * @return string
     */
    public function getDepartDate()
    {
        return $this->departDate;
    }

    /**
     * @param string $departDate
     */
    public function setDepartDate($departDate)
    {
        $this->departDate = $departDate;
    }

    /**
     * @return string
     */
    public function getArriveeDate()
    {
        return $this->arriveeDate;
    }

    /**
     * @param string $arriveeDate
     */
    public function setArriveeDate($arriveeDate)
    {
        $this->arriveeDate = $arriveeDate;
    }

    /**
     * @return string
     */
    public function getDuree()
    {
        return $this->duree;
    }

    /**
     * @param string $duree
     */
    public function setDuree($duree)
    {
        $this->duree = $duree;
    }

    /**
     * @return string
     */
    public function getDistance()
    {
        return $this->distance;
    }

    /**
     * @param string $distance
     */
    public function setDistance($distance)
    {
        $this->distance = $distance;
    }

    /**
     * @return mixed
     */
    public function getRoad()
    {
        return $this->road;
    }

    /**
     * @param mixed $road
     */
    public function setRoad($road)
    {
        $this->road = $road;
    }

    /**
     * @return mixed
     */
    public function getExtraData()
    {
        return $this->extraData;
    }

    /**
     * @param mixed $extraData
     */
    public function setExtraData($extraData)
    {
        $this->extraData = $extraData;
    }

    public function toArray()
    {

        return [
            "type"=>$this->getTypeJourney(),
            "typePoint"=>$this->getTypePoints(),
            "depart"=>$this->getDepartPoint()->toArray(),
            "arrivee"=>$this->getArriveePoint()->toArray(),
            "departDate"=>$this->getDepartDate(),
            "arriveeDate"=>$this->getArriveeDate(),
            "duree"=>$this->getDuree(),
            "distance"=>$this->getDistance(),
            "road"=>$this->getRoad(),
            "extraData"=>$this->getExtraData()
        ];
    }

}