<?php


namespace Actigraph\CarteBundle\Service\BackObj;


class JourneyStepAttente implements JourneyStep
{
    /** @var string $typeJourney */
    private $typeJourney ="ATTENTE";

    /** @var string $typePoints */
    private $typePoints ="";

    /** @var RemotePointItem $waitingPoint */
    private $waitingPoint ="";

    /** @var string $waitinEndDate */
    private $waitingStartDate ="";

    /** @var string $waitinEndDate */
    private $waitinEndDate ="";

    /** @var string $duree */
    private $duree ="";

    /**
     * @return string
     */
    public function getTypeJourney()
    {
        return $this->typeJourney;
    }

    /**
     * @param string $typeJourney
     */
    public function setTypeJourney($typeJourney)
    {
        $this->typeJourney = $typeJourney;
    }

    /**
     * @return string
     */
    public function getTypePoints()
    {
        return $this->typePoints;
    }

    /**
     * @param string $typePoints
     */
    public function setTypePoints($typePoints)
    {
        $this->typePoints = $typePoints;
    }

    /**
     * @return RemotePointItem
     */
    public function getWaitingPoint()
    {
        return $this->waitingPoint;
    }

    /**
     * @param RemotePointItem $waitingPoint
     */
    public function setWaitingPoint($waitingPoint)
    {
        $this->waitingPoint = $waitingPoint;
    }

    /**
     * @return string
     */
    public function getWaitingStartDate()
    {
        return $this->waitingStartDate;
    }

    /**
     * @param string $waitingStartDate
     */
    public function setWaitingStartDate($waitingStartDate)
    {
        $this->waitingStartDate = $waitingStartDate;
    }

    /**
     * @return string
     */
    public function getWaitinEndDate()
    {
        return $this->waitinEndDate;
    }

    /**
     * @param string $waitinEndDate
     */
    public function setWaitinEndDate($waitinEndDate)
    {
        $this->waitinEndDate = $waitinEndDate;
    }

    /**
     * @return string
     */
    public function getDuree()
    {
        return $this->duree;
    }

    /**
     * @param string $duree
     */
    public function setDuree($duree)
    {
        $this->duree = $duree;
    }

    public function toArray()
    {
        return [
            "type"=>$this->getTypeJourney(),
            "typePoint"=>$this->getTypePoints(),
            "waitingPoint"=>$this->getWaitingPoint()->toArray(),
            "waitingStartDate"=>$this->getWaitingStartDate(),
            "waitingEndDate"=>$this->getWaitingStartDate(),
            "duree"=>$this->getDuree(),
        ];
    }
}