<?php


namespace Actigraph\CarteBundle\Service\BackObj;
use Actigraph\CarteBundle\Entity\ObjectWithBackObj;


class JourneyPerturbation implements ObjectWithBackObj
{

    /** @var string $externalCode */
    private $externalCode="";

    /**

    /** @var string $name */
    private $name="";


    /** @var string $description */
    private $description="";

    /** @var \DateTime $debut */
    private $debut;

    /** @var \DateTime $fin */
    private $fin;

    /** @var []ObjectWithBackObj $lignes */
    private $lignes;

    /**
    * @return string
    */
    public function getExternalCode()
    {
        return $this->externalCode;
    }

    /**
     * @param string $externalCode
     */
    public function setExternalCode($externalCode)
    {
        $this->externalCode = $externalCode;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return \DateTime
     */
    public function getDebut()
    {
        return $this->debut;
    }

    /**
     * @param \DateTime $debut
     */
    public function setDebut($debut)
    {
        $this->debut = $debut;
    }

    /**
     * @return \DateTime
     */
    public function getFin()
    {
        return $this->fin;
    }

    /**
     * @param \DateTime $fin
     */
    public function setFin($fin)
    {
        $this->fin = $fin;
    }

    /**
     * @return mixed
     */
    public function getLignes()
    {
        return $this->lignes;
    }

    /**
     * @param mixed $lignes
     */
    public function setLignes($lignes): void
    {
        $this->lignes = $lignes;
    }

    public function toArray(){

        $lignesData = [];

        if($this->getLignes() != null && count($this->getLignes())>0){
            foreach ($this->getLignes() as $ligne){
                $lignesData[]=$ligne->toArray();
            }
        }


        return [
            "externalCode"=>$this->getExternalCode(),
            "name"=>$this->getName(),
            "description"=>$this->getDescription(),
            "debut"=>$this->getDebut(),
            "fin"=>$this->getFin(),
            "lignes"=>$lignesData
        ];
    }


}