<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 03/09/2019
 * Time: 14:00
 */

namespace Actigraph\CarteBundle\Service\Back;

use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Entity\Ligne;
use Actigraph\CarteBundle\Service\BackObj\RemoteInfoTrafic;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigne;
use Actigraph\CarteBundle\Service\BackObj\RemotePointItem;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopArea;
use Actigraph\CarteBundle\Service\BackObj\RemoteVille;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopLines;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopTimeTable;
use Actigraph\CarteBundle\Service\BackObj\RemoteLineTimeTable;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Validator\Constraints\Date;
use Actigraph\CarteBundle\Service\BackObj\RemoteLigneDirection;
use Actigraph\CarteBundle\Service\BackObj\Journey;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepTransport;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepAttente;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepPied;
use Actigraph\CarteBundle\Service\BackObj\JourneyStepBike;
use Actigraph\CarteBundle\Service\BackObj\JourneyPerturbation;

class NavitiaBack implements BackInterface, BackJourneyTransportCommun, BackJourneyTransportVelo, BackAutocomplete
{
    private $config;
    private $em;
    public function __construct(EntityManagerInterface $em, $backConfig)
    {
        $this->em = $em;
        $this->config = $backConfig;
    }


    public function NavitiaIORequest($link) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $link);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}

        curl_close($curl);
        $results =  json_decode($result, true);

        return $results;
    }

    /**
     * Recuperation des villes depuis le backoffice
     * @return RemoteVille[] Liste des viles distants
     */
    public function listVilles() : array {
        $listVilles = [];

        $urlApi = $this->config["url"]."/coverage/".$this->config["coverage"]."/stop_areas";
        $listVilleArray = $this->listItemInNavitiaRequest($urlApi, "stop_areas");

        $IdAlreadyImported = [];
        if(!empty($listVilleArray)){
            foreach ($listVilleArray as $ville) {
                if(!isset($ville["administrative_regions"])){
                    continue;
                }

                $city = end($ville["administrative_regions"]);
                if(in_array($city["insee"],$IdAlreadyImported)) //Si j'ai déja importé le stoparea du stoppoint alors je passe au suivant
                    continue;

                $currentVille = new RemoteVille();
                $currentVille->setExternalCode($city["id"]);
                $currentVille->setName($city["name"]);
                $currentVille->setLat($city["coord"]["lat"]);
                $currentVille->setLng($city["coord"]["lon"]);
                $currentVille->setCodePostal($city["zip_code"]);

                $listVilles[]=$currentVille;
                $IdAlreadyImported[]=$city["insee"];
            }
        }


        return $listVilles;
    }

    public function listItemInNavitiaRequest($link, $indexsearch):array{
        $listStopAreaArray = [];
        $nextLink = null;
        $resultRequest = $this->NavitiaIORequest($link);
        if(isset($resultRequest[$indexsearch]) && is_array($resultRequest[$indexsearch])){
            $listStopAreaArray = array_merge($listStopAreaArray, $resultRequest[$indexsearch]);
            $nextLink = null;
            foreach ($resultRequest["links"] as $links){
                if($links["type"] == "next") {
                    $nextLink = $links["href"];
                }
            }

            if(!is_null($nextLink)) {
                $listStopAreaArray = array_merge($listStopAreaArray, $this->listItemInNavitiaRequest($nextLink, $indexsearch));
            } else {
                $listStopAreaArray = array_merge($listStopAreaArray, $resultRequest[$indexsearch]);
            }
        }

        return $listStopAreaArray;
    }

    /**
     * Recuperation des stoparea depuis le backoffice
     * @return RemoteStopArea[] Liste des arrêts distants
     */
    public function listStoparea() : array {
        $listStopArea = [];

        $urlApi = $this->config["url"]."/coverage/".$this->config["coverage"]."/stop_areas";
        $listStopAreaArray = $this->listItemInNavitiaRequest($urlApi, "stop_areas");

        $logicalIdAlreadyImported = [];

        if(!empty($listStopAreaArray)){
            foreach ($listStopAreaArray as $stopArea) {
                if(!isset($stopArea["administrative_regions"])){
                    continue;
                }
                $city = end($stopArea["administrative_regions"]);
                if(in_array($stopArea["id"],$logicalIdAlreadyImported)) //Si j'ai déja importé le stoparea du stoppoint alors je passe au suivant
                    continue;

                $currentStop = new RemoteStopArea();
                $currentStop->setCoordLng($stopArea["coord"]["lon"]);
                $currentStop->setCoordLat($stopArea["coord"]["lat"]);
                $currentStop->setExternalCode($stopArea["id"]);
                $currentStop->setName($stopArea["name"]);
                $isPmr = false;
                $currentStop->setAccessiblePmr($isPmr);
                $currentStop->setVilleExternalCode($city["id"]);

                $listStopArea[]=$currentStop;
                $logicalIdAlreadyImported[]=$stopArea["id"];
            }
        }

        return $listStopArea;
    }

    public function listPoiByTypeExternalCode(string $typeExternalCode,array $extraParams) : array{
        return [];
    }

    public function listLignes(): array{
        $listLignes = [];
        $urlApi = $this->config["url"]."/coverage/".$this->config["coverage"]."/lines";
        $listlinesArray = $this->listItemInNavitiaRequest($urlApi, "lines");
        if(!empty($listlinesArray)){
            foreach ($listlinesArray as $lines) {
                $directions = [];
                foreach ($lines["routes"] as $dir){
                    $dirObj = new RemoteLigneDirection();
                    $dirObj->setExternalCode($dir["id"]);
                    $dirObj->setName($dir["direction"]["stop_area"]["name"]);
                    $directions[]=$dirObj;
                }
                $ligne = new RemoteLigne();
                $ligne->setExternalCode($lines["id"]);
                $ligne->setName($lines["code"]);
                $ligne->setShortName($lines["code"]);
                $ligne->setLigneBackgroundColor($lines["color"]);
                $ligne->setLigneTextColor($lines["text_color"]);
                $ligne->setDirections($directions);
                $listLignes[]=$ligne;
            }
        }

        return $listLignes;
    }

    public function listCurrentInfosTrafics(): array{
        $listPerturbations = [];

        return $listPerturbations;
    }

    public function stopLines($text){
        $stopLine = new RemoteStopLines();

        return $stopLine;
    }

    public function getStopTimetable($stopId, $lineId, $direction, $date) {
        $stopTimeTable = new RemoteStopTimeTable();

        return $stopTimeTable;

    }

    public function getLineTimetable($lineid, $direction) {
        $lineTimeTable = new RemoteLineTimeTable();

        return $lineTimeTable;
    }

    private function extractDateTimeFromString($string){
        // /Date(1547442000000+0100)/
        $tmp = explode("(",$string);
        $tmp = explode("+",$tmp[1]);
        $stringTimestamp = substr($tmp[0],0,10);
        $date = new \DateTime();
        $date->setTimestamp($stringTimestamp);
        return $date;
    }

    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi{
        //Pas d'infos temps réel ou complémentaire en plus
        return $poi;
    }

    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array{
        //Pas d'infos temps réel ou complémentaire en plus
        return $this->listPoiByTypeExternalCode($typeExternalCode,$extraParams);
    }

    public function autocomplete($text): array
    {
        $allSuggestions = [];
        $requestNavitia = $this->NavitiaIORequest($this->config["url"]."/coverage/".$this->config["coverage"]."/places?display_geojson=false&count=25&q=".urlencode($text));

        if(isset($requestNavitia["places"])){
            foreach ($requestNavitia["places"] as $suggest){
                $suggestion = new RemotePointItem();

                $name = "";
                if($suggest["embedded_type"] == "stop_area") {
                    $suggestion->setType(RemotePointItem::TYPE_STOPAREA);
                    $suggestion->setCoordLat($suggest["stop_area"]["coord"]["lat"]);
                    $suggestion->setCoordLng($suggest["stop_area"]["coord"]["lon"]);

                    $name = $suggest["name"];
                } elseif($suggest["embedded_type"] == "administrative_region") {
                    $suggestion->setCoordLat($suggest["administrative_region"]["coord"]["lat"]);
                    $suggestion->setCoordLng($suggest["administrative_region"]["coord"]["lon"]);
                    $suggestion->setType(RemotePointItem::TYPE_ADRESSE);

                    $name = $suggest["name"];
                } elseif($suggest["embedded_type"] == "poi") {
                    $suggestion->setCoordLat($suggest["poi"]["coord"]["lat"]);
                    $suggestion->setCoordLng($suggest["poi"]["coord"]["lon"]);
                    $suggestion->setType(RemotePointItem::TYPE_POI);

                    $name = $suggest["name"];
                    if(isset($suggest["poi"]["address"])){
                        $name .= " - ";

                        if($suggest["poi"]["address"]["house_number"] != 0){
                            $name .= " ".$suggest["poi"]["address"]["house_number"];
                        }

                        $name .= " ".$suggest["poi"]["address"]["name"];
                    }
                } elseif($suggest["embedded_type"] == "address") {
                    $suggestion->setCoordLat($suggest["address"]["coord"]["lat"]);
                    $suggestion->setCoordLng($suggest["address"]["coord"]["lon"]);
                    $suggestion->setType(RemotePointItem::TYPE_ADRESSE);

                    $name = $suggest["name"];
                }

                $suggestion->setName($name);

                $suggestion->setExternalCode($suggest["id"]);
                $allSuggestions[] = $suggestion;
            }
        }

        return $allSuggestions;
    }

    public function getJourneyTransportCommun($from,$to,$dateTime,$dateTimeRepresent, $extra, $infotrafics): array {
        $allTrips = [];
        $requestNavitia = $this->NavitiaIORequest($this->config["url"]."/coverage/".$this->config["coverage"]."/journeys?from=".$from."&to=".$to."&datetime=".$dateTime."&datetime_represents=".$dateTimeRepresent."&min_nb_journeys=3");

        if(isset($requestNavitia["journeys"]) && !empty($requestNavitia["journeys"])) {
            $allTrips = $this->getJourney($requestNavitia["journeys"], $infotrafics);
        }

        return $allTrips;
    }

    public function getJourney($journeyData, $infotrafics){
        $allJourney = [];
        $infosTrafic = $infotrafics;
        $allInfoTrafic = [];
        foreach ($infosTrafic as $info){
            $infoTrafic = ["externalCode"=>$info->getExternalCode(), "name"=>$info->getName(), "description"=>$info->getDescription(),"debut"=>$info->getDebut(),"fin"=>$info->getFin(), "DisruptedLines"=>$info->getLignes()];
            foreach ($info->getLignes() as $ligne){
                $allInfoTrafic[$ligne->getExternalCode()][] = $infoTrafic;
            }
        }

        foreach ($journeyData as $trip) {
            $journey = new Journey();
            $startWait = $this->convertNavitiaDateToDate($trip["departure_date_time"]);
            $endWait = $this->convertNavitiaDateToDate($trip["arrival_date_time"]);

            $journey->setDepartDate($startWait->getTimestamp());
            $journey->setArriveeDate($endWait->getTimestamp());
            $journey->setTypeJourney("TC");
            $departure = reset($trip["sections"]);
            $arrival = end($trip["sections"]);

            $journey->setDepartPoint($this->GetPoint($departure["from"]));
            $journey->setArriveePoint($this->GetPoint($arrival["to"]));
            $journey->setDistance("");
            $journey->setDuree($trip["duration"]);

            $sections = $trip["sections"];
            $sections = $this->getJourneySections($sections, $allInfoTrafic);


            $journey->setSections($sections);

            array_push($allJourney, $journey);
        }

        return $allJourney;
    }

    private function getJourneySections($sections, $allInfoTrafic){
        $tripSections = [];
        $nextSection = null;
        foreach ($sections as $key=>$section){
            $nextSection = null;
            $sectionTrip = null;
            if(isset($sections[$key+1]))
                $nextSection = $sections[$key+1];

            if (isset($section["mode"]) && $section["mode"] == "walking") {
                $sectionTrip = $this->LegSection($section);
            } elseif (isset($section["type"]) && $section["type"] == "waiting" ) {
                $sectionTrip = $this->AwaitSection($section, $nextSection);
            } elseif(isset($section["type"]) && $section["type"] == "transfer"){
                $sectionTrip = $this->LegSection($section);
            } else {
                $sectionTrip = $this->PTRideSection($section, $allInfoTrafic);
            }

            array_push($tripSections, $sectionTrip);
        }

        return $tripSections;
    }

    private function AwaitSection($sectionWait, $nextSection){
        $sectionAttente = new JourneyStepAttente();
        $startWait = $this->convertNavitiaDateToDate($sectionWait["departure_date_time"]);
        $endWait = $this->convertNavitiaDateToDate($sectionWait["arrival_date_time"]);

        $sectionAttente->setWaitingStartDate($startWait->getTimestamp());
        $sectionAttente->setWaitinEndDate($endWait->getTimestamp());

        $sectionAttente->setDuree($sectionWait["duration"]);
        $sectionAttente->setWaitingPoint($this->GetPoint($nextSection["from"]));

        return $sectionAttente;

    }

    private function LegSection($sectionLeg){
        $section = new JourneyStepPied();
        $startWait = $this->convertNavitiaDateToDate($sectionLeg["departure_date_time"]);
        $endWait = $this->convertNavitiaDateToDate($sectionLeg["arrival_date_time"]);
        $section->setDepartDate($startWait->getTimestamp());
        $section->setArriveeDate($endWait->getTimestamp());
        $section->setDepartPoint($this->GetPoint($sectionLeg["from"]));
        $section->setArriveePoint($this->GetPoint($sectionLeg["to"]));
        $section->setDuree($sectionLeg["duration"]);

        if(isset($sectionLeg["geojson"])) {
            $section->setGeojson($sectionLeg["geojson"]);
        }

        return $section;
    }

    private function PTRideSection($ptrideSection, $allInfoTrafic){
        $section = new JourneyStepTransport();
        $perturb = [];
        if(!empty($allInfoTrafic) && isset($allInfoTrafic["line:".$ptrideSection["display_informations"]["name"]])){
            foreach ($allInfoTrafic["line:".$ptrideSection["display_informations"]["name"]] as $info){
                $infoTrafic = new JourneyPerturbation();
                $infoTrafic->setExternalCode($info["externalCode"]);
                $infoTrafic->setName($info["name"]);
                $infoTrafic->setDescription($info["description"]);
                $infoTrafic->setDebut($info["debut"]);
                $infoTrafic->setFin($info["fin"]);
                $perturbLignes = [];

                if(isset($info["DisruptedLines"]) && is_array($info["DisruptedLines"]) && count($info["DisruptedLines"])>0){
                    foreach ($info["DisruptedLines"] as $ligneRaw){
                        $perturbLignes[] = $ligneRaw;
                    }
                }
                $infoTrafic->setLignes($perturbLignes);
                $perturb[] = $infoTrafic;
            }
        }

        if(isset($ptrideSection["type"]) && $ptrideSection["type"] === "on_demand_transport")
            $section->setIsTAD(true);

        $section->setPerturbations($perturb);
        $startWait = $this->convertNavitiaDateToDate($ptrideSection["departure_date_time"]);
        $endWait = $this->convertNavitiaDateToDate($ptrideSection["arrival_date_time"]);
        $section->setDepartDate($startWait->getTimestamp());
        $section->setArriveeDate($endWait->getTimestamp());
        $section->setDepartPoint($this->GetPoint($ptrideSection["from"]));
        $section->setArriveePoint($this->GetPoint($ptrideSection["to"]));
        $section->setDuree($ptrideSection["duration"]);
        $ligne = new RemoteLigne();

        $ligneDbOrigin =  $this->em->getRepository(Ligne::class)->findOneBy(["externalCode"=>"line:".$ptrideSection["display_informations"]["name"]]);

        if(!is_null($ligneDbOrigin)) {
            $ligne->setExternalCode($ligneDbOrigin->getExternalCode());
        } else {
            $ligne->setExternalCode("line:".$ptrideSection["display_informations"]["name"]);
        }

        $ligne->setDirections([]);
        $section->setDirection($ptrideSection["display_informations"]["direction"]);
        $dirObj = new RemoteLigneDirection();
        $dirObj->setName($ptrideSection["display_informations"]["direction"]);
        $directions[]=$dirObj;
        $ligne->setDirections($directions);
        $section->setLignes($ligne);
        $section->setStopareas($this->getStopAreaInStep($ptrideSection["stop_date_times"]));

        return $section;
    }

    private function getStopAreaInStep($steps){
        $stopsArea = [];
        foreach ($steps as $step){
            $currentStop = new RemoteStopArea();
            $currentStop->setCoordLng($step["stop_point"]["coord"]["lon"]);
            $currentStop->setCoordLat($step["stop_point"]["coord"]["lat"]);
            $currentStop->setExternalCode($step["stop_point"]["id"]);
            $currentStop->setName($step["stop_point"]["name"]);
            $isPmr = false;
            $currentStop->setAccessiblePmr($isPmr);
            array_push($stopsArea, $currentStop);

        }
        return $stopsArea;
    }


    private function GetPoint($section){
        $point = new RemotePointItem();
        $point->setName($section["name"]);
        if(is_null($section["id"]))
            $point->setExternalCode("null");
        else
            $point->setExternalCode($section["id"]);

        $point->setType($this->getPointType($section["embedded_type"]));
        if(isset($section["stop_area"])) {
            $point->setCoordLat(floatval($section["stop_area"]["coord"]["lat"]));
            $point->setCoordLng(floatval($section["stop_area"]["coord"]["lon"]));
        } elseif (isset($section["administrative_region"])){
            $point->setCoordLat(floatval($section["administrative_region"]["coord"]["lat"]));
            $point->setCoordLng(floatval($section["administrative_region"]["coord"]["lon"]));
        } elseif (isset($section["stop_point"])){
            $point->setCoordLat(floatval($section["stop_point"]["coord"]["lat"]));
            $point->setCoordLng(floatval($section["stop_point"]["coord"]["lon"]));
        } elseif (isset($section["address"])){
            $point->setCoordLat(floatval($section["address"]["coord"]["lat"]));
            $point->setCoordLng(floatval($section["address"]["coord"]["lon"]));
        } elseif (isset($section["poi"])){
            $point->setCoordLat(floatval($section["poi"]["coord"]["lat"]));
            $point->setCoordLng(floatval($section["poi"]["coord"]["lon"]));
        }

        return $point;
    }

    public function convertNavitiaDateToDate($navitiaDate){

        $dateTmp = explode("T", $navitiaDate);
        $dateBlock = $dateTmp[0];
        $heureBlock = $dateTmp[1];
        $dateYear = substr($dateBlock, 0, 4);
        $dateMonth = substr($dateBlock, 4, 2);
        $dateDay = substr($dateBlock, 6, 2);
        $timeHour = substr($heureBlock, 0, 2);
        $timeMinute = substr($heureBlock, 2, 2);
        $timeSecond = substr($heureBlock, 4, 2);

        return \DateTime::createFromFormat("d/m/Y H:i:s", $dateDay."/".$dateMonth."/".$dateYear." ".$timeHour.":".$timeMinute.":".$timeSecond);
    }

    public function getJourneyVelo($from,$to,$dateTime,$dateTimeRepresent, $extra){
        $allTrips = [];
        return $allTrips;

    }

    public function getTripBike($journeyData){
        $allJourney = [];

        return $allJourney;
    }

    public function getJourneySectionsBike($sectionData) {
        $tripSections = [];

        return $tripSections;
    }

    public function BikeSection($section) {
        $bikeSection = new JourneyStepBike();

        return $bikeSection;
    }

    private function getPointType($type){
        if($type == "stop_area") {
            return RemotePointItem::TYPE_STOPAREA;
        } else if($type == "administrative_region") {
            return RemotePointItem::TYPE_ADRESSE;
        } else if($type == "stop_point") {
            return RemotePointItem::TYPE_STOPPOINT;
        }else if($type == "poi") {
            return RemotePointItem::TYPE_POI;
        }else if($type == "address") {
            return RemotePointItem::TYPE_ADRESSE;
        }
    }
}
