<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 11/06/2019
 * Time: 09:17
 */

namespace Actigraph\CarteBundle\Service\Back;
use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Service\BackObj\RemotePoi;
use Doctrine\ORM\EntityManagerInterface;


class NantesMetropole implements BackInterface {


    private $config;
    private $em;
    public function __construct(EntityManagerInterface $em, $backConfig)
    {
        $this->em = $em;
        $this->config = $backConfig;
    }

    public function listVilles(): array
    {
        return [];
    }

    public function listStoparea(): array
    {
        return [];
    }

    public function listLignes(): array
    {
        return [];
    }

    public function listCurrentInfosTrafics(): array
    {
        return [];
    }

    public function listPoiByTypeExternalCode(string $typeExternalCode, array $extraParams): array
    {
        $listeStations = [];
        $url = $url = $this->config["url"];

        if($typeExternalCode == 3)
            $url .= "/api/records/1.0/search/?dataset=244400404_abris-velos-nantes-metropole&facet=commune&facet=conditions&facet=gestionnaire";
        elseif($typeExternalCode == 4)
            $url .= "/api/records/1.0/search/?dataset=244400404_parcs-relais-nantes-metropole&facet=libtype&facet=commune&facet=service_velo&facet=autres_service_mob_prox&facet=conditions_d_acces&facet=exploitant&rows=200";
        else
            return $listeStations;

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        $response = curl_exec($curl);
        curl_close($curl);

        if ($response == "") {
            return $listeStations;
        } else {
            $poiListe = json_decode($response);
            foreach ($poiListe->records as $poi) {
                $remotePoi = new RemotePoi();
                if($typeExternalCode == 4)
                    $nom = $poi->fields->nom_complet;
                else
                    $nom = $poi->fields->nom;
                if(isset($poi->fields->geo_shape)){
                    $remotePoi->setLng($poi->fields->geo_shape->coordinates["0"]);
                    $remotePoi->setLat($poi->fields->geo_shape->coordinates["1"]);
                }else if(isset($poi->fields->location)){
                    $remotePoi->setLng($poi->fields->location["1"]);
                    $remotePoi->setLat($poi->fields->location["0"]);
                }else if(isset($poi->geometry)){
                    $remotePoi->setLng($poi->geometry->coordinates["0"]);
                    $remotePoi->setLat($poi->geometry->coordinates["1"]);
                }else{
                    continue; //pas de coord donc on ignore
                }

                $remotePoi->setName($nom." (".$poi->fields->commune.")");
                $remotePoi->setExternalCode((string)"NM".md5($nom));

                $extraParams = [];
                $extraParams["adresse"] = $poi->fields->adresse;
                $extraParams["ville"] = array(
                    "name" => (string)$poi->fields->commune
                );
                if($typeExternalCode == 2) {
                    $extraParams["capacite"]= $poi->fields->capacite;
                } elseif($typeExternalCode == 4){
                    $extraParams["capacitevoiture"]= $poi->fields->capacite_voiture;
                    if(!isset($poi->fields->capacite_velo) && isset($poi->fields->stationnement_velo_securise) && $poi->fields->stationnement_velo_securise == "NON"){
                        $extraParams["capacitevelo"] = 0;
                        $extraParams["stationnement_velo"] = 0;
                    }else{
                        $extraParams["capacitevelo"]= $poi->fields->capacite_velo;
                        $extraParams["stationnement_velo"] = 1;
                    }

                    if(isset($poi->fields->capacite_pmr))
                        $extraParams["capacitepmr"]= $poi->fields->capacite_pmr;
                    if(isset($poi->fields->idobj))
                        $extraParams["idobj"]= $poi->fields->idobj;

                    $extraParams["precisions"]=$poi->fields->presentation;
                    $extraParams["conditionacces"]=($poi->fields->conditions_d_acces == "Libre") ? 1 : 0;
                }

                $remotePoi->setExtraData($extraParams);
                $listeStations[]=$remotePoi;

            }
        }

        return $listeStations;
    }

    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi
    {
        if($typeExternalCode == 4){
            $extra = $poi->getExtraData();
            if(isset($extra["idobj"])){
                $searchIdObj = (string)$extra["idobj"];

                $url = $url = $this->config["url"];
                $url .= "/api/records/1.0/search/?dataset=244400404_parcs-relais-nantes-metropole-disponibilites&q=&facet=grp_nom&facet=grp_statut&rows=200";
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($curl, CURLOPT_TIMEOUT, 5);
                $resp = curl_exec($curl);
                $results = json_decode($resp);

                foreach($results->records as $result){
                    if(isset($result->fields) && isset($result->fields->idobj) && (string)$result->fields->idobj == $searchIdObj){
                        if(isset($result->fields->grp_disponible))
                            $extra["nbrPlacesDispo"] = $result->fields->grp_disponible;
                    }
                }
            }
            $poi->setExtraData($extra);
        }
        return $poi;
    }

    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array
    {
        if($typeExternalCode == 2){
            $url = $url = $this->config["url"];
            $url .= "/api/records/1.0/search/?dataset=244400404_stations-velos-libre-service-nantes-metropole-disponibilites&facet=banking&facet=bonus&facet=status&facet=contract_name&rows=200&apikey=b98a790a67d4b0378816b5898e79b61f45d0f77daa4d8cc834087e28";
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_TIMEOUT, 5);
            $resp = curl_exec($curl);

            $results = json_decode($resp);

            foreach($results->records as $result){
                $placeDispo[] = array("id"=>$result->fields->number, "placelibre"=>$result->fields->available_bikes);
            }


        }
        return $pois;
    }
}
