import * as $ from "jquery"
import * as L from "leaflet"
import * as d3 from "d3"

class GeoJSONGridLayer extends L.GridLayer{
    style : any;
    lines : any;
    _url : any;
    _map : any;
    _removeAllTiles : any;
    _update : any;
    _path : any;
    _zoomAnimated : any;
    options : any;
    div : any;
    divPopUp: any;

    constructor(url: any, STYLE: any, lines:any, options: any) {
        super();
        this.style = STYLE;
        this._url = url;
        this.lines = lines;
    }

    redraw () {
        $('.leaflet-overlay-pane svg.svg-lines').empty().append('');
        if (this._map) {
            this._removeAllTiles();
            this._update();
        }
        return this;
    }

    onAdd (map) {
        let self = this;
        this._zoomAnimated = false;
        this._map = map;
        L.GridLayer.prototype.onAdd.call(this, map);
        let transform = d3.geoTransform({point: function(x,y){
            let point = map.latLngToLayerPoint(new L.LatLng(y, x));
            this.stream.point(point.x, point.y);
        }});
        this._path = d3.geoPath().projection(transform);
        this.div = d3.select("body").append("div")
            .attr("class", "tooltip")
            .style("opacity", 0);
        this.divPopUp = d3.select(".leaflet-popup-pane").append("div").attr("class", "leaflet-popup popupline").style("display", "none");
        this._map.on('zoomstart', function () {
            $('.leaflet-overlay-pane svg.svg-lines').hide();
        });
        this._map.on('zoomend', function () {
            self.redraw();
            $('.leaflet-overlay-pane svg.svg-lines').show();

        });
    }

    createTile (coords, done) {
        let tile = L.DomUtil.create('div', 'leaflet-tile');
        this.fetchTile(tile, coords, function (error) {
            done(error);
        });
        return tile;
    }
    
    fetchTile (tile,coords, done) {
        let vm = this;
        let map = this._map;
        let style = this.style;
        let tileUrl = L.Util.template(this._url, coords);
        let tileLayer = this;
        let request = new XMLHttpRequest();
        request.open('GET', tileUrl, true);
        request.onload = function () {
            if (request.status >= 200 && request.status < 400) {
                let data = JSON.parse(request.responseText);
                //tile.div = d3.select("body").append("div");
                if (style.linesCanHaveBorder()) {
                    tile.nodesBorder = d3.select(map.getPanes().overlayPane).select("svg").attr("class", "svg-lines").append("g");
                    tile.nodeBorder = tile.nodesBorder.selectAll("path")
                        .data(data.features).enter()
                        .append("path")
                        .attr("class", "leaflet-clickable")
                        .attr("data-border", "border")
                        .attr("d", tileLayer._path)
                        .attr("style", function(section) {
                            return style.getBorderStyle(section, vm.lines);
                        })
                        .on("mouseover", function(){
                            style.handleMouseOver(this, tileLayer)
                        })
                        .on("mouseout", function(){
                            style.handleMouseOut(tileLayer)
                        })
                        .on("mousemove", function(){
                            style.handleMouseMove(this, tileLayer)
                        })
                        .on("click", function(){
                            style.handleClick(this, tileLayer)
                        });
                }
                tile.monnode = d3.select(map.getPanes().overlayPane).select("svg").attr("class", "svg-lines").append("g");
                tile.monnode.selectAll("path")
                    .data(data.features).enter()
                    .append("path")
                    .attr("class", "leaflet-clickable")
                    .attr("ligneId", function(section) {
                        return section.properties.ligneId
                    })
                    .attr("props", function(section) {
                        return JSON.stringify(section.properties)
                    })
                    .attr("d", tileLayer._path)
                    .attr("style", function(section) {
                        return style.getStyle(section, vm.lines);
                    })
                    .on("mouseover", function(section){
                        let linecode = section.properties.code_ligne;
                        style.handleMouseOver(this, tileLayer)
                    })
                    .on("mouseout", function(){
                        style.handleMouseOut(tileLayer)
                    })
                    .on("mousemove", function(){
                        style.handleMouseMove(this, tileLayer)
                    })
                    .on("click", function(){
                        style.handleClick(this, tileLayer)
                    });

                done(null);
            } else {
                done(request.statusText);
            }
        };
        request.onerror = function () {
            done(request.statusText);
        };

        request.send();
    }
}

export { GeoJSONGridLayer };
