import * as $ from "jquery"
import * as L from "leaflet"
import {BaseCarto} from "./basecarto"
import {Networkstop} from "./networkstop"
import {StyleGestion} from "./stylegestion"
import {Pois} from "./pois"

import {Networkstoprender} from "../../../../../assets/js/render/pois/networkstoprender"

const NEWTWORKSTOPRENDER = new Networkstoprender();


class EventsMap {
    basecarto : BaseCarto;
    tooltip : L.tooltip;
    asLineDrawn : boolean = false;
    constructor(basecarto : BaseCarto) {
        this.basecarto = basecarto;
    }

    addMapEvent(){
        let vm = this;
        $('#map').on("click", function(){
            $('.popupline .leaflet-popup-close-button').click();
        });
        BaseCarto.map.dragging.enable();
        BaseCarto.map.touchZoom.enable();
        BaseCarto.map.doubleClickZoom.enable();
        BaseCarto.map.scrollWheelZoom.enable();

        $("#map").on("click",function(){
            if(BaseCarto.configuration.blocage) {
                BaseCarto.map.dragging.enable();
                BaseCarto.map.touchZoom.enable();
                BaseCarto.map.doubleClickZoom.enable();
                BaseCarto.map.scrollWheelZoom.enable();
            }
        });
        $("#map").on("touchstart",function(){
            if(BaseCarto.configuration.blocage) {
                BaseCarto.map.dragging.enable();
                BaseCarto.map.touchZoom.enable();
                BaseCarto.map.doubleClickZoom.enable();
                BaseCarto.map.scrollWheelZoom.enable();
            }
        });

        $(".leaflet-popup-pane").on("click",".leaflet-popup-close-button",function(e){
            e.stopPropagation();
            $(".popupline").css("display", "none");
            return false;
        });

        BaseCarto.map.on("zoomstart", function() {
            $(".leaflet-popup-pane .popupline").css("opacity",0);
            $(".leaflet-popup-pane .popupline").css("display","none");
        });

        BaseCarto.map.on("moveend", function () {
            vm.basecarto.displayMarker("Pois");
            vm.basecarto.displayMarker("networkStop");
            vm.basecarto.updatePanneaux();
        });

        $("#map").on("click", ".selectPoi-item", function () {
            let poiId = $(this).attr("data-id");
            let poiConcerned = Pois.pois.find(function(e){ return  e.id === parseInt(poiId) });
            poiConcerned.display = !poiConcerned.display;

            vm.basecarto.displayMarker("Pois");
        });

        $("#map").on("click", "#choose-poi", function () {
            if($('#selectPois-content').is(":visible"))
                $('#selectPois-content').hide();
            else 
                $('#selectPois-content').show();
        });
    }

    redrawWithNewImportantLine(lines:string[], fromHoraireLine = false, forceRedraw = false){
        StyleGestion.showOnlyLine = lines;
        if(Networkstop.isItiStopArea) {
            if(typeof BaseCarto.lineLayer  !== "undefined")
                BaseCarto.lineLayer.redraw()
        } else if(fromHoraireLine) {
            this.asLineDrawn = true;
            if(typeof BaseCarto.lineLayer  !== "undefined")
                BaseCarto.lineLayer.redraw()
        } else if(forceRedraw){
            if(Networkstop.isItiStopArea || this.asLineDrawn) {
                this.asLineDrawn = false;
                if(typeof BaseCarto.lineLayer  !== "undefined")
                    BaseCarto.lineLayer.redraw()
            }
        }
    }

    focusOnStopArea(suggestion, coords){
        let coord = new L.LatLng(coords.lat, coords.lng);
        BaseCarto.map.setView(coord, 17);
        var popup = L.popup()
            .setLatLng(coord);
        let contentPopup = NEWTWORKSTOPRENDER.generatePopUpStopArea(suggestion.data);
        popup.setContent(contentPopup)
            .openOn(BaseCarto.map);

    }

    identifyStopArea(suggestion, coords){
        let coord = new L.LatLng(coords.lat, coords.lng);
        BaseCarto.map.setView(coord,  BaseCarto.map.getZoom());
        let tootlitp = L.tooltip()
            .setContent("<div class='label-marker'/>" + suggestion.data.name + "</div>")
            .setLatLng(coord);

        this.tooltip = tootlitp;
        tootlitp.addTo(BaseCarto.map)
    }

    destroyPopUp(){
        BaseCarto.map.closePopup();
    }

    destroyTooltip(){
        BaseCarto.map.closeTooltip(this.tooltip);
    }

}


export { EventsMap };

