<?php


namespace Actigraph\CarteBundle\Service\BackObj;


class JourneyStepTransport implements JourneyStep
{

    /** @var string $typeJourney */
    private $typeJourney ="TRANSPORT";

    /** @var string $typePoints */
    private $typePoints ="";

    /** @var RemotePointItem $departPoint */
    private $departPoint ="";

    /** @var RemotePointItem $arriveePoint */
    private $arriveePoint ="";

    /** @var string $departDate */
    private $departDate ="";

    /** @var string $arriveeDate */
    private $arriveeDate ="";

    /** @var string $duree */
    private $duree ="";

    /** @var $stopareas */
    private $stopareas;

    /** @var ObjectWithBackObj $lignes */
    private $lignes;

    /** @var string $direction */
    private $direction ="";

    /** @var [] $perturbations */
    private $perturbations = [];

    /** @var boolean $isTAD */
    private $isTAD = false;

    /**
     * @return string
     */
    public function getTypeJourney()
    {
        return $this->typeJourney;
    }

    /**
     * @param string $typeJourney
     */
    public function setTypeJourney($typeJourney)
    {
        $this->typeJourney = $typeJourney;
    }

    /**
     * @return string
     */
    public function getTypePoints()
    {
        return $this->typePoints;
    }

    /**
     * @param string $typePoints
     */
    public function setTypePoints($typePoints)
    {
        $this->typePoints = $typePoints;
    }

    /**
     * @return RemotePointItem
     */
    public function getDepartPoint()
    {
        return $this->departPoint;
    }

    /**
     * @param RemotePointItem $departPoint
     */
    public function setDepartPoint($departPoint)
    {
        $this->departPoint = $departPoint;
    }

    /**
     * @return RemotePointItem
     */
    public function getArriveePoint()
    {
        return $this->arriveePoint;
    }

    /**
     * @param RemotePointItem $arriveePoint
     */
    public function setArriveePoint($arriveePoint)
    {
        $this->arriveePoint = $arriveePoint;
    }

    /**
     * @return string
     */
    public function getDepartDate()
    {
        return $this->departDate;
    }

    /**
     * @param string $departDate
     */
    public function setDepartDate($departDate)
    {
        $this->departDate = $departDate;
    }

    /**
     * @return string
     */
    public function getArriveeDate()
    {
        return $this->arriveeDate;
    }

    /**
     * @param string $arriveeDate
     */
    public function setArriveeDate($arriveeDate)
    {
        $this->arriveeDate = $arriveeDate;
    }

    /**
     * @return string
     */
    public function getDuree()
    {
        return $this->duree;
    }

    /**
     * @param string $duree
     */
    public function setDuree($duree)
    {
        $this->duree = $duree;
    }

    /**
     * @return mixed
     */
    public function getStopareas()
    {
        return $this->stopareas;
    }

    /**
     * @param mixed $stopareas
     */
    public function setStopareas($stopareas)
    {
        $this->stopareas = $stopareas;
    }

    /**
     * @return mixed
     */
    public function getLignes()
    {
        return $this->lignes;
    }

    /**
     * @param mixed $lignes
     */
    public function setLignes($lignes)
    {
        $this->lignes = $lignes;
    }

    /**
     * @return string
     */
    public function getDirection()
    {
        return $this->direction;
    }

    /**
     * @param string $direction
     */
    public function setDirection($direction)
    {
        $this->direction = $direction;
    }

    /**
     * @return []
     */
    public function getPerturbations()
    {
        return $this->perturbations;
    }

    /**
     * @param [] $perturbations
     */
    public function setPerturbations($perturbations)
    {
        $this->perturbations = $perturbations;

        return $this;
    }

    /**
     * @return bool
     */
    public function isTAD()
    {
        return $this->isTAD;
    }

    /**
     * @param bool $isTAD
     */
    public function setIsTAD($isTAD)
    {
        $this->isTAD = $isTAD;
    }

    public function toArray()
    {

        $stopAreas = [];
        foreach ($this->getStopareas() as $stoparea){
            if($stoparea != "")
                $stopAreas[]=$stoparea->toArray();
        }

        $perturbations = [];

        foreach ($this->getPerturbations() as $perturbation){
            $perturbations[] = $perturbation->toArray();
        }

        $lignes = [];
        if(!is_string($this->getLignes())){
            $lignes = $this->getLignes()->toArray();
        }

        return [
            "type"=>$this->getTypeJourney(),
            "typePoint"=>$this->getTypePoints(),
            "depart"=>$this->getDepartPoint()->toArray(),
            "arrivee"=>$this->getArriveePoint()->toArray(),
            "departDate"=>$this->getDepartDate(),
            "arriveeDate"=>$this->getArriveeDate(),
            "duree"=>$this->getDuree(),
            "stopArea"=>$stopAreas,
            "lines"=>$lignes,
            "direction"=>$this->getDirection(),
            "perturbations"=>$perturbations,
            "isTAD"=>$this->isTAD()
        ];
    }
}