<?php


namespace Actigraph\CarteBundle\Service\Back;


use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Service\BackObj\RemotePoi;
use Doctrine\ORM\EntityManagerInterface;

class MobilityTechGreenBack implements BackInterface {

    private $config;

    private $em;
    public function __construct(EntityManagerInterface $em, $backConfig)
    {
        $this->em = $em;
        $this->config = $backConfig;
    }

    public function listVilles(): array
    {
        return [];
    }

    public function listStoparea(): array
    {
        return [];
    }

    public function listLignes(): array
    {
        return [];
    }

    public function listCurrentInfosTrafics($date=null): array
    {
        return [];
    }

    public function listPoiByTypeExternalCode(string $typeExternalCode, array $extraParams): array
    {
        $listeStations = array();

        $curl = curl_init();

        $now = new \DateTime();
        $formatedDate=$now->format("d.m.Y H:i:s");
        $hashSecurity = strtoupper(hash_hmac('sha256', $this->config["login"].$formatedDate, $this->config["shakey"]));

        $payload = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        $payload .= "<soap12:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap12=\"http://www.w3.org/2003/05/soap-envelope\">\n";
        $payload .= "<soap12:Body>\n";
        $payload .= "<GetStationsByCity xmlns=\"http://www.mobilitytechgreen.com/\">\n";
        $payload .= "<sOperatorLogin>".$this->config["login"]."</sOperatorLogin>\n";
        $payload .= "<sOperatorPassword>".$this->config["password"]."</sOperatorPassword>\n";
        $payload .= "<sUpdateTimeStamp>".$formatedDate."</sUpdateTimeStamp>\n";
        $payload .= "<sSecurityValue>".$hashSecurity."</sSecurityValue>\n";
        $payload .= "<iVilleID>".$this->config["idVille"]."</iVilleID>\n";
        $payload .= "</GetStationsByCity>\n";
        $payload .= "</soap12:Body>\n";
        $payload .= "</soap12:Envelope>";

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->config["url"],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 2,
            CURLOPT_TIMEOUT => 2,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/soap+xml",
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        if ($response == "" || strpos($response, "soap:") == false) {
            return $listeStations;
        } else {
            $response = str_replace('soap:', '', $response);
            $xml = simplexml_load_string($response);
            if(!isset($xml->Body->GetStationsByCityResponse->GetStationsByCityResult)){
                return $listeStations;
            }
            foreach ($xml->Body->GetStationsByCityResponse->GetStationsByCityResult->Donnees->wsStation as $station) {
                $lat = $station->sParkLatitude/100000;
                $lng = $station->sParkLongitude/100000;

                $remotePoi = new RemotePoi();
                $remotePoi->setLng($lng);
                $remotePoi->setLat($lat);
                $remotePoi->setName($station->sParkNom." (".$station->sVillNom.")");
                $remotePoi->setExternalCode((string)$station->iParkingID);
                $extraParams = [];

                $extraParams["adresse"] = trim($station->sParkAdresse1." ".$station->sParkAdresse2);
                $extraParams["ville"] = array(
                    "name"=>(string)$station->sVillNom
                );
                if($station->bDisponible == "true")
                    $extraParams["dispo"]= true;
                else
                    $extraParams["dispo"]= false;
                $remotePoi->setExtraData($extraParams);
                $listeStations[]=$remotePoi;
            }
        }
        return $listeStations;
    }

    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi
    {
        $listeStations = $this->listPoiByTypeExternalCode($typeExternalCode,$extraParams);
        if(count($listeStations)==0)
            return $poi;
        $newExtraData = [];
        /** @var RemotePoi $station */
        foreach ($listeStations as $station){
            if($station->getExternalCode() == $poi->getExternalCode()){
                $newExtraData=$station->getExtraData();
            }
        }

        $poi->setExtraData($newExtraData);
        return $poi;
    }

    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array
    {
        return $pois;
    }
}
