<?php


namespace Actigraph\CarteBundle\Service\Back;


use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Service\BackObj\RemoteVille;
use Doctrine\ORM\EntityManagerInterface;

interface BackInterface
{
    public function __construct(EntityManagerInterface $entityManager, $backConfig);
    public function listVilles(): array;
    public function listStoparea(): array;
    public function listLignes(): array;
    public function listCurrentInfosTrafics($date=null): array;
    public function listPoiByTypeExternalCode(string $typeExternalCode,array $extraParams): array;
    public function updatePoiExtraData(Poi $poi,string $typeExternalCode,array $extraParams): Poi;
    public function listUpdatedPoiExtraDataByTypeExternalCode(array $pois,string $typeExternalCode,array $extraParams): array;
}
